/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.print;

import com.lightcrafts.ui.print.ButtonPanel;
import com.lightcrafts.ui.print.CenteredCheckBox;
import com.lightcrafts.ui.print.ColorManagementPanel;
import com.lightcrafts.ui.print.PositionPanel;
import com.lightcrafts.ui.print.PreviewPanel;
import com.lightcrafts.ui.print.PrintLayoutModel;
import com.lightcrafts.ui.print.SizePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

class PrintLayoutPanel
extends JPanel {
    private PreviewPanel preview;
    private ColorManagementPanel color;
    private PositionPanel position;
    private SizePanel size;
    private JCheckBox centered;
    private ButtonPanel buttons;

    PrintLayoutPanel(PrintLayoutModel model, BufferedImage image) {
        this.preview = new PreviewPanel(image, model);
        this.color = new ColorManagementPanel(model);
        this.position = new PositionPanel(model);
        this.size = new SizePanel(model);
        this.centered = new CenteredCheckBox(model);
        this.buttons = new ButtonPanel();
        Box numbersBox = Box.createVerticalBox();
        numbersBox.add(this.position);
        numbersBox.add(this.size);
        PrintLayoutPanel.addEmptyBorder(this);
        PrintLayoutPanel.addEmptyBorder(this.preview);
        PrintLayoutPanel.addEmptyBorder(this.color);
        PrintLayoutPanel.addEmptyBorder(this.position);
        PrintLayoutPanel.addEmptyBorder(this.size);
        PrintLayoutPanel.addEmptyBorder(this.centered);
        PrintLayoutPanel.addEmptyBorder(this.buttons);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 2;
        this.add((Component)this.preview, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridheight = 1;
        c.gridwidth = 2;
        this.add((Component)this.color, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 2;
        this.add((Component)numbersBox, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridheight = 1;
        c.gridwidth = 2;
        c.anchor = 10;
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.centered);
        box.add(Box.createHorizontalGlue());
        this.add((Component)box, c);
        c.gridx = 2;
        c.gridy = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 3;
        c.anchor = 13;
        this.add((Component)this.buttons, c);
        this.registerKeyboardActions();
    }

    void addPrintAction(ActionListener action) {
        this.buttons.addPrintAction(action);
    }

    void addCancelAction(ActionListener action) {
        this.buttons.addCancelAction(action);
    }

    void addDoneAction(ActionListener action) {
        this.buttons.addDoneAction(action);
    }

    void addPageSetupAction(ActionListener action) {
        this.buttons.addPrintSetupAction(action);
    }

    private static void addEmptyBorder(JComponent comp) {
        Border oldBorder = comp.getBorder();
        Border empty = BorderFactory.createEmptyBorder(3, 3, 3, 3);
        Border newBorder = oldBorder != null ? BorderFactory.createCompoundBorder(empty, oldBorder) : empty;
        comp.setBorder(newBorder);
    }

    private void registerKeyboardActions() {
        ActionListener commitAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PrintLayoutPanel.this.buttons.doDoneActions();
            }
        };
        ActionListener cancelAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PrintLayoutPanel.this.buttons.doCancelActions();
            }
        };
        this.registerKeyboardAction(commitAction, "Commit", KeyStroke.getKeyStroke(10, 0), 1);
        this.registerKeyboardAction(cancelAction, "Cancel", KeyStroke.getKeyStroke(27, 0), 1);
    }

    public static void main(String[] args) throws Exception {
        BufferedImage image = ImageIO.read(new File(args[0]));
        JPanel panel = new JPanel(new BorderLayout());
        int width = image.getWidth();
        int height = image.getHeight();
        PrintLayoutModel model = new PrintLayoutModel(width, height);
        PrintLayoutPanel test = new PrintLayoutPanel(model, image);
        panel.add(test);
        JFrame frame = new JFrame("PositionPanel Test");
        frame.setContentPane(panel);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

