/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.print;

import com.lightcrafts.platform.Platform;
import com.lightcrafts.platform.PrinterLayer;
import com.lightcrafts.ui.print.PrintLayoutModel;
import com.lightcrafts.ui.print.PrintLayoutPanel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import javax.swing.UIManager;

public class PrintLayoutDialog
extends JDialog {
    private PrintLayoutModel model;
    private PrintLayoutPanel panel;

    public PrintLayoutDialog(BufferedImage image, PrintLayoutModel model, Frame parent, String title) {
        super(parent, title, true);
        this.model = model;
        this.panel = new PrintLayoutPanel(model, image);
        this.setContentPane(this.panel);
        this.setResizable(false);
    }

    public PageFormat getPageFormat() {
        return this.model.getPageFormat();
    }

    public void setPageFormat(PageFormat format) {
        this.model.setPageFormat(format);
    }

    public PrintLayoutModel getPrintLayout() {
        return this.model;
    }

    public void addPrintAction(ActionListener listener) {
        this.panel.addPrintAction(listener);
    }

    public void addCancelAction(ActionListener listener) {
        this.panel.addCancelAction(listener);
    }

    public void addDoneAction(ActionListener listener) {
        this.panel.addDoneAction(listener);
    }

    public void addPageSetupAction(ActionListener listener) {
        this.panel.addPageSetupAction(listener);
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(Platform.getPlatform().getLookAndFeel());
        BufferedImage image = ImageIO.read(new File(args[0]));
        int w = image.getWidth();
        int h = image.getHeight();
        final PrintLayoutDialog dialog = new PrintLayoutDialog(image, new PrintLayoutModel(w, h), null, "PrintLayoutDialog Test");
        dialog.addPrintAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                System.out.println("print");
            }
        });
        dialog.addPageSetupAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PrinterLayer printer = Platform.getPlatform().getPrinterLayer();
                PageFormat format = printer.pageDialog(null);
                if (format != null) {
                    dialog.setPageFormat(format);
                }
            }
        });
        dialog.addCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                System.out.println("cancel");
                dialog.dispose();
            }
        });
        dialog.addDoneAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                System.out.println("done");
                dialog.dispose();
            }
        });
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }
}

