/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.print;

import com.lightcrafts.ui.LightZoneSkin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.ComboBoxEditor;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

class PpiComboBox
extends JComboBox
implements ActionListener,
DocumentListener {
    private static final Preferences Prefs = Preferences.userNodeForPackage(PpiComboBox.class);
    private static final String RecentPpiTag = "RecentPpi";
    private static final String CurrentPpiTag = "CurrentPpi";
    private static final int MaxItemCount = 5;
    private boolean isRestoring;

    PpiComboBox() {
        this.setEditable(true);
        this.addActionListener(this);
        JTextComponent text = this.getTextComponent();
        Document doc = text.getDocument();
        doc.addDocumentListener(this);
        Font font = new JTextField().getFont();
        this.setFont(font);
        text.setFont(font);
        text.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JTextComponent text = (JTextComponent)e.getSource();
                text.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                JTextComponent text = (JTextComponent)e.getSource();
                text.select(0, 0);
            }
        });
        text.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent comp) {
                return PpiComboBox.this.verify();
            }
        });
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PpiComboBox.this.savePrefs();
                }
            }
        });
        Dimension size = this.getPreferredSize();
        this.setPreferredSize(new Dimension(30, size.height));
        this.restorePrefs();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean verified = this.verify();
        if (!verified) {
            return;
        }
        String text = (String)this.editor.getItem();
        this.setItem(text);
    }

    void setPpi(int ppi) {
        String text = Integer.toString(ppi);
        this.setItem(text);
    }

    int getPpi() {
        String text = (String)this.getSelectedItem();
        if (text != null) {
            return Integer.parseInt(text);
        }
        return 0;
    }

    private void setItem(String text) {
        for (int n = 0; n < this.getItemCount(); ++n) {
            String item = (String)this.getItemAt(n);
            if (!item.equals(text)) continue;
            this.setSelectedItem(item);
            this.savePrefs();
            return;
        }
        this.addItem(text);
        while (this.getItemCount() > 5) {
            this.removeItemAt(0);
        }
        this.setSelectedItem(text);
        this.savePrefs();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.handleDocumentChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.handleDocumentChange();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.handleDocumentChange();
    }

    private void handleDocumentChange() {
        boolean verified = this.verify();
        JTextComponent text = this.getTextComponent();
        if (!verified) {
            text.setForeground(Color.red);
        } else {
            text.setForeground(LightZoneSkin.Colors.ToolPanesForeground);
        }
    }

    private JTextComponent getTextComponent() {
        return (JTextComponent)this.editor.getEditorComponent();
    }

    private boolean verify() {
        ComboBoxEditor editor = this.getEditor();
        String text = (String)editor.getItem();
        try {
            int ppi = Integer.parseInt(text);
            return ppi > 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void savePrefs() {
        if (!this.isRestoring) {
            for (int n = 0; n < this.getItemCount(); ++n) {
                String item = (String)this.getItemAt(n);
                Prefs.put(RecentPpiTag + n, item);
            }
            String item = (String)this.getSelectedItem();
            if (item != null) {
                Prefs.put(CurrentPpiTag, item);
            } else {
                Prefs.remove(CurrentPpiTag);
            }
        }
    }

    private void restorePrefs() {
        this.isRestoring = true;
        try {
            Object[] keys = Prefs.keys();
            Arrays.sort(keys);
            for (Object key : keys) {
                String item;
                if (!((String)key).startsWith(RecentPpiTag) || (item = Prefs.get((String)key, null)) == null) continue;
                this.addItem(item);
            }
            String item = Prefs.get(CurrentPpiTag, null);
            if (item != null) {
                this.setSelectedItem(item);
            }
        }
        catch (BackingStoreException e) {
            System.err.println("Error restoring PpiComboBox values: " + e.getMessage());
        }
        this.isRestoring = false;
    }

    public static void main(String[] args) {
        JPanel panel = new JPanel();
        panel.add(new PpiComboBox());
        panel.add(new JButton("x"));
        JFrame frame = new JFrame();
        frame.setContentPane(panel);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

