/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.print;

import com.lightcrafts.ui.print.DimensionTextField;
import com.lightcrafts.ui.print.Locale;
import com.lightcrafts.ui.print.PrintLayoutModel;
import com.lightcrafts.ui.print.PrintLayoutModelListener;
import com.lightcrafts.ui.print.UnitComboBox;
import java.awt.BorderLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

class PositionPanel
extends JPanel
implements PrintLayoutModelListener {
    private PrintLayoutModel model;
    private DimensionTextField leftText;
    private UnitComboBox leftUnit;
    private DimensionTextField topText;
    private UnitComboBox topUnit;
    private boolean readingFromModel;
    private boolean writingToModel;
    private JPanel titlePanel;

    PositionPanel(PrintLayoutModel model) {
        this.model = model;
        model.addListener(this);
        this.titlePanel = new JPanel();
        this.titlePanel.setLayout(new BoxLayout(this.titlePanel, 1));
        TitledBorder border = BorderFactory.createTitledBorder(Locale.LOCALE.get("PositionTitle"));
        this.titlePanel.setBorder(border);
        this.addLeft();
        this.titlePanel.add(Box.createVerticalStrut(3));
        this.addTop();
        this.setLayout(new BorderLayout());
        this.add(this.titlePanel);
    }

    private void addLeft() {
        this.leftText = new DimensionTextField();
        this.leftUnit = new UnitComboBox();
        this.updateLeft();
        this.leftText.setListener(new DimensionTextField.Listener(){

            @Override
            public void dimensionChanged(double left) {
                if (!PositionPanel.this.readingFromModel) {
                    PositionPanel.this.writingToModel = true;
                    PrintLayoutModel.LengthUnit unit = PositionPanel.this.leftUnit.getSelectedUnit();
                    PositionPanel.this.model.setImageX(left, unit);
                    PositionPanel.this.writingToModel = false;
                }
            }
        });
        PositionPanel.syncTextWithUnit(this.leftText, this.leftUnit);
        Box box = PositionPanel.createLabelledText(Locale.LOCALE.get("LeftLabel"), this.leftText, this.leftUnit);
        this.titlePanel.add(box);
    }

    private void addTop() {
        this.topText = new DimensionTextField();
        this.topUnit = new UnitComboBox();
        this.updateTop();
        this.topText.setListener(new DimensionTextField.Listener(){

            @Override
            public void dimensionChanged(double top) {
                if (!PositionPanel.this.readingFromModel) {
                    PositionPanel.this.writingToModel = true;
                    PrintLayoutModel.LengthUnit unit = PositionPanel.this.topUnit.getSelectedUnit();
                    PositionPanel.this.model.setImageY(top, unit);
                    PositionPanel.this.writingToModel = false;
                }
            }
        });
        PositionPanel.syncTextWithUnit(this.topText, this.topUnit);
        Box box = PositionPanel.createLabelledText(Locale.LOCALE.get("TopLabel"), this.topText, this.topUnit);
        this.titlePanel.add(box);
    }

    private static void syncTextWithUnit(final DimensionTextField text, final UnitComboBox unit) {
        unit.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    double oldDim = text.getDimension();
                    PrintLayoutModel.LengthUnit oldUnit = text.getUnit();
                    PrintLayoutModel.LengthUnit newUnit = unit.getSelectedUnit();
                    double newDim = newUnit.fromPoints(oldUnit.toPoints(oldDim));
                    text.setUnit(newUnit);
                    text.setDimension(newDim);
                }
            }
        });
    }

    private static Box createLabelledText(String name, DimensionTextField text, UnitComboBox units) {
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(new JLabel(name + ':'));
        box.add(Box.createHorizontalStrut(3));
        box.add(text);
        box.add(Box.createHorizontalStrut(3));
        box.add(units);
        return box;
    }

    private void updateTop() {
        double y = this.model.getImageRect().getY();
        PrintLayoutModel.LengthUnit unit = this.topUnit.getSelectedUnit();
        y = unit.fromPoints(y);
        this.topText.setUnit(unit);
        this.topText.setDimension(y);
    }

    private void updateLeft() {
        double x = this.model.getImageRect().getX();
        PrintLayoutModel.LengthUnit unit = this.leftUnit.getSelectedUnit();
        x = unit.fromPoints(x);
        this.leftText.setUnit(unit);
        this.leftText.setDimension(x);
    }

    @Override
    public void layoutChanged(PrintLayoutModel source) {
        if (!this.writingToModel) {
            this.readingFromModel = true;
            this.updateLeft();
            this.updateTop();
            this.readingFromModel = false;
        }
    }

    public static void main(String[] args) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(new PositionPanel(new PrintLayoutModel(100, 100)));
        JFrame frame = new JFrame("PositionPanel Test");
        frame.setContentPane(panel);
        frame.setLocation(100, 100);
        frame.pack();
        frame.setVisible(true);
    }
}

