/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation.zone;

import com.lightcrafts.model.Operation;
import com.lightcrafts.model.ZoneOperation;
import com.lightcrafts.ui.layout.Box;
import com.lightcrafts.ui.operation.OpControl;
import com.lightcrafts.ui.operation.OpStack;
import com.lightcrafts.ui.operation.zone.ZoneContainer;
import com.lightcrafts.ui.operation.zone.ZoneScaleButtons;
import com.lightcrafts.ui.operation.zone.ZoneWidget;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.Dimension;

public class ZoneControl
extends OpControl {
    private static final Dimension PreferredSize = new Dimension(160, 256);
    private ZoneWidget widget;
    private ZoneScaleButtons scales;

    public ZoneControl(ZoneOperation op, OpStack stack) {
        super(op, stack);
        this.widget = new ZoneWidget(op, this.undoSupport);
        this.widget.setBackground(Background);
        this.scales = new ZoneScaleButtons(op, this.undoSupport);
        this.scales.setBackground(Background);
        this.scales.setFont(ControlFont);
        ZoneWidget reference = new ZoneWidget(op, null);
        reference.setBackground(Background);
        reference.setEnabled(false);
        this.readyForUndo();
        ZoneContainer zones = new ZoneContainer(this.widget, reference);
        zones.setBackground(Background);
        zones.setPreferredSize(PreferredSize);
        Box container = Box.createVerticalBox();
        container.add(zones);
        container.add(this.scales);
        this.setContent(container);
    }

    @Override
    protected void operationChanged(Operation operation) {
        super.operationChanged(operation);
        this.widget.operationChanged((ZoneOperation)operation);
        this.scales.operationChanged((ZoneOperation)operation);
    }

    @Override
    public void save(XmlNode node) {
        super.save(node);
        this.widget.save(node);
        this.scales.save(node);
    }

    @Override
    public void restore(XmlNode node) throws XMLException {
        super.restore(node);
        this.undoSupport.restoreStart();
        this.widget.restore(node);
        this.scales.restore(node);
        this.undoSupport.restoreEnd();
    }

    @Override
    protected String getHelpTopic() {
        return "Tool-ZoneMapper";
    }
}

