/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation.zone;

import com.lightcrafts.ui.operation.zone.Spacer;
import com.lightcrafts.ui.operation.zone.ZoneWidget;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;

class SpacerTraversalPolicy
extends FocusTraversalPolicy {
    SpacerTraversalPolicy() {
    }

    @Override
    public Component getDefaultComponent(Container cont) {
        return this.getFirstSpacer((ZoneWidget)cont);
    }

    @Override
    public Component getFirstComponent(Container cont) {
        return this.getFirstSpacer((ZoneWidget)cont);
    }

    @Override
    public Component getLastComponent(Container cont) {
        return this.getLastSpacer((ZoneWidget)cont);
    }

    @Override
    public Component getComponentAfter(Container cont, Component comp) {
        Spacer previous = this.getPreviousSpacer((ZoneWidget)cont, (Spacer)comp);
        if (previous != null) {
            return previous;
        }
        return this.getLastSpacer((ZoneWidget)cont);
    }

    @Override
    public Component getComponentBefore(Container cont, Component comp) {
        Spacer next = this.getNextSpacer((ZoneWidget)cont, (Spacer)comp);
        if (next != null) {
            return next;
        }
        return this.getFirstSpacer((ZoneWidget)cont);
    }

    private Spacer getFirstSpacer(ZoneWidget zones) {
        return this.getSpacerAt(zones, 0);
    }

    private Spacer getLastSpacer(ZoneWidget zones) {
        Spacer last;
        Spacer first;
        Spacer next = first = this.getFirstSpacer(zones);
        do {
            last = next;
        } while ((next = this.getNextSpacer(zones, next)) != null);
        return last;
    }

    private Spacer getNextSpacer(ZoneWidget zones, Spacer spacer) {
        int index = this.getIndexOf(spacer);
        return this.getSpacerAt(zones, index + 1);
    }

    private Spacer getPreviousSpacer(ZoneWidget zones, Spacer spacer) {
        int index = this.getIndexOf(spacer);
        return this.getSpacerAt(zones, index - 1);
    }

    private int getIndexOf(Spacer spacer) {
        return spacer.getIndex();
    }

    private Spacer getSpacerAt(ZoneWidget zones, int index) {
        Component[] comps = zones.getComponents();
        for (int n = 0; n < comps.length; ++n) {
            Spacer spacer;
            int i;
            Component comp = comps[n];
            if (!(comp instanceof Spacer) || (i = (spacer = (Spacer)comp).getIndex()) != index) continue;
            return spacer;
        }
        return null;
    }
}

