/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation.whitebalance;

import com.lightcrafts.model.ColorDropperOperation;
import com.lightcrafts.model.Operation;
import com.lightcrafts.ui.editor.EditorMode;
import com.lightcrafts.ui.layout.Box;
import com.lightcrafts.ui.mode.DropperMode;
import com.lightcrafts.ui.operation.OpStack;
import com.lightcrafts.ui.operation.generic.GenericControl;
import com.lightcrafts.ui.operation.whitebalance.Locale;
import com.lightcrafts.ui.toolkit.DropperButton;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class ColorDropperControl
extends GenericControl {
    private DropperButton dropperButton;
    private DropperMode dropperMode;
    private Box colorContent;
    private boolean isDropperModeCancelling;

    public ColorDropperControl(ColorDropperOperation op, OpStack stack) {
        super(op, stack);
    }

    @Override
    protected void operationChanged(Operation operation) {
        super.operationChanged(operation);
        this.dropperButton = new DropperButton();
        this.dropperButton.setAlignmentX(1.0f);
        this.dropperButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                boolean selected;
                boolean bl = selected = event.getStateChange() == 1;
                if (selected) {
                    ColorDropperControl.this.getComboFrame().getEditor().setMode(EditorMode.ARROW);
                    ColorDropperControl.this.notifyListenersEnterMode(ColorDropperControl.this.dropperMode);
                } else if (!ColorDropperControl.this.isDropperModeCancelling) {
                    ColorDropperControl.this.notifyListenersExitMode(ColorDropperControl.this.dropperMode);
                }
            }
        });
        this.dropperMode = new DropperMode(this);
        this.dropperMode.addListener(new DropperMode.Listener(){

            @Override
            public void pointSelected(Point2D p) {
                ColorDropperControl.this.setColor(p);
            }

            @Override
            public void modeCancelled() {
                ColorDropperControl.this.isDropperModeCancelling = true;
                ColorDropperControl.this.dropperButton.setSelected(false);
                ColorDropperControl.this.isDropperModeCancelling = false;
            }
        });
        this.colorContent = Box.createHorizontalBox();
        this.colorContent.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.colorContent.add(Box.createHorizontalStrut(8));
        this.colorContent.add(this.dropperButton);
        JComponent content = this.getContent();
        content.add(this.colorContent);
    }

    Box getColorContent() {
        return this.colorContent;
    }

    private void setColor(Point2D p) {
        ColorDropperOperation op = (ColorDropperOperation)this.getOperation();
        Map<String, Float> sliders = op.setColor(p);
        for (String key : sliders.keySet()) {
            double value = sliders.get(key).floatValue();
            this.slewSlider(key, value);
        }
        if (!this.undoSupport.isRestoring()) {
            this.undoSupport.postEdit(Locale.LOCALE.get("PickWhiteBalanceEditName"));
        }
    }
}

