/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation.generic;

import com.lightcrafts.model.GenericOperation;
import com.lightcrafts.model.Operation;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.SliderConfig;
import com.lightcrafts.ui.layout.Box;
import com.lightcrafts.ui.operation.OpControl;
import com.lightcrafts.ui.operation.OpStack;
import com.lightcrafts.ui.operation.generic.GenericSlider;
import com.lightcrafts.ui.operation.generic.GenericSliderContainer;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GenericControl
extends OpControl {
    private static final ResourceBundle Resources = ResourceBundle.getBundle("com/lightcrafts/ui/operation/generic/GenericControl");
    private GenericOperation op;
    private Map sliders = new HashMap();
    private Map checkboxes = new HashMap();
    private Map choices = new HashMap();
    private static final String SliderTag = "Slider";
    private static final String CheckBoxTag = "Checkbox";
    private static final String ChoiceTag = "Choice";

    public GenericControl(GenericOperation op, OpStack stack) {
        super(op, stack);
        this.operationChanged(op);
        this.readyForUndo();
    }

    @Override
    protected void operationChanged(Operation operation) {
        super.operationChanged(operation);
        this.op = (GenericOperation)operation;
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalStrut(6));
        GenericSliderContainer sliderContainer = new GenericSliderContainer();
        List sliderKeys = this.op.getSliderKeys();
        for (final String key : sliderKeys) {
            String userKey = this.getUserPresentableKey(key);
            SliderConfig config = this.op.getSliderConfig(key);
            final GenericSlider slider = new GenericSlider(userKey, config);
            slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent event) {
                    double value = slider.getConfiguredValue();
                    GenericControl.this.op.setSliderValue(key, value);
                }
            });
            GenericSlider oldSlider = (GenericSlider)this.sliders.get(key);
            if (oldSlider != null) {
                slider.setConfiguredValue(oldSlider.getConfiguredValue());
            }
            slider.addSliderMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    GenericControl.this.op.changeBatchStarted();
                }

                @Override
                public void mouseReleased(MouseEvent event) {
                    GenericControl.this.op.changeBatchEnded();
                    GenericControl.this.undoSupport.postEdit(key + " Slider");
                }
            });
            slider.setBackgroundRecurse(Background);
            slider.setFontRecurse(ControlFont);
            sliderContainer.addGenericSlider(slider);
            this.sliders.put(key, slider);
        }
        sliderContainer.setBackground(Background);
        box.add(sliderContainer);
        List checkboxKeys = this.op.getCheckboxKeys();
        for (final String key : checkboxKeys) {
            String userKey = this.getUserPresentableKey(key);
            final JCheckBox checkbox = new JCheckBox(userKey);
            checkbox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    boolean value = checkbox.isSelected();
                    GenericControl.this.op.setCheckboxValue(key, value);
                    GenericControl.this.undoSupport.postEdit(key + " Checkbox");
                }
            });
            JCheckBox oldCheckbox = (JCheckBox)this.checkboxes.get(key);
            if (oldCheckbox != null) {
                checkbox.setSelected(oldCheckbox.isSelected());
            }
            checkbox.setBackground(Background);
            checkbox.setFont(ControlFont);
            box.add(checkbox);
            this.checkboxes.put(key, checkbox);
        }
        List choiceKeys = this.op.getChoiceKeys();
        for (final String key : choiceKeys) {
            Vector values = new Vector(this.op.getChoiceValues(key));
            final JComboBox choice = new JComboBox(values);
            choice.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    String value = (String)choice.getSelectedItem();
                    GenericControl.this.op.setChoiceValue(key, value);
                    GenericControl.this.undoSupport.postEdit(key + " Choice");
                }
            });
            JComboBox oldChoice = (JComboBox)this.choices.get(key);
            if (oldChoice != null) {
                choice.setSelectedItem(oldChoice.getSelectedItem());
            }
            choice.setBackground(Background);
            choice.setFont(ControlFont);
            box.add(choice);
            this.choices.put(key, choice);
        }
        box.add(Box.createVerticalStrut(6));
        this.setContent(box);
        this.undoSupport.initialize();
    }

    protected void slewSlider(String key, double value) {
        GenericSlider slider = (GenericSlider)this.sliders.get(key);
        if (slider != null) {
            slider.setConfiguredValue(value);
        }
    }

    private String getUserPresentableKey(String key) {
        OperationType type = this.op.getType();
        String name = type.getName();
        name = name.replaceAll(" ", "");
        String propKey = name + "-" + key;
        try {
            return Resources.getString(propKey);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    @Override
    public void save(XmlNode node) {
        super.save(node);
        XmlNode sliderNode = node.addChild(SliderTag);
        Set keys = this.sliders.keySet();
        for (String key : keys) {
            GenericSlider slider = (GenericSlider)this.sliders.get(key);
            double value = slider.getConfiguredValue();
            sliderNode.setAttribute(key, Double.toString(value));
        }
        XmlNode checkboxNode = node.addChild(CheckBoxTag);
        keys = this.checkboxes.keySet();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            String key;
            JCheckBox checkbox = (JCheckBox)this.checkboxes.get(key = (String)i.next());
            boolean value = checkbox.isSelected();
            checkboxNode.setAttribute(key, value ? "True" : "False");
        }
        XmlNode choiceNode = node.addChild(ChoiceTag);
        keys = this.choices.keySet();
        for (String key : keys) {
            JComboBox choice = (JComboBox)this.choices.get(key);
            String value = (String)choice.getSelectedItem();
            choiceNode.setAttribute(key, value);
        }
    }

    @Override
    public void restore(XmlNode node) throws XMLException {
        Set keys;
        super.restore(node);
        this.undoSupport.restoreStart();
        this.op.changeBatchStarted();
        if (node.hasChild(SliderTag)) {
            XmlNode sliderNode = node.getChild(SliderTag);
            keys = this.sliders.keySet();
            for (String key : keys) {
                GenericSlider slider = (GenericSlider)this.sliders.get(key);
                try {
                    int version = sliderNode.getVersion();
                    if (version >= 3 || version < 0) {
                        double value = Double.parseDouble(sliderNode.getAttribute(key));
                        slider.setConfiguredValue(value);
                        continue;
                    }
                    int value = Integer.parseInt(sliderNode.getAttribute(key));
                    slider.setSliderPosition(value);
                }
                catch (NumberFormatException e) {
                    throw new XMLException("Value at attribute \"" + key + "\" is not a number", e);
                }
            }
        }
        if (node.hasChild(CheckBoxTag)) {
            XmlNode checkboxNode = node.getChild(CheckBoxTag);
            keys = this.checkboxes.keySet();
            for (String key : keys) {
                JCheckBox checkbox = (JCheckBox)this.checkboxes.get(key);
                String value = checkboxNode.getAttribute(key);
                checkbox.setSelected(value.equals("True"));
            }
        }
        if (node.hasChild(ChoiceTag)) {
            XmlNode choiceNode = node.getChild(ChoiceTag);
            keys = this.choices.keySet();
            for (String key : keys) {
                JComboBox choice = (JComboBox)this.choices.get(key);
                String value = choiceNode.getAttribute(key);
                choice.setSelectedItem(value);
            }
        }
        this.op.changeBatchEnded();
        this.undoSupport.restoreEnd();
    }

    @Override
    protected String getHelpTopic() {
        OperationType type = this.op.getType();
        String name = type.getName();
        if (name.startsWith("ZoneMapper")) {
            return "Tool-ZoneMapper";
        }
        if (name.startsWith("UnSharp Mask")) {
            return "Tool-Sharpen";
        }
        if (name.startsWith("Gaussian Blur")) {
            return "Tool-Blur";
        }
        if (name.startsWith("Hue/Saturation")) {
            return "Tool-Hue_Saturation";
        }
        if (name.startsWith("Color Balance")) {
            return "Tool-Color_Balance";
        }
        if (name.startsWith("White Point")) {
            return "Tool-White_Balance";
        }
        if (name.startsWith("Channel Mixer")) {
            return "Tool-Black_and_White";
        }
        if (name.startsWith("Advanced Noise Reduction")) {
            return "Tool-Noise_Reduction";
        }
        if (name.startsWith("Clone")) {
            return "Tool-Clone";
        }
        if (name.startsWith("Spot")) {
            return "Tool-Spot";
        }
        if (name.startsWith("RAW Adjustments")) {
            return "Tool-Raw_Adjustments";
        }
        if (name.startsWith("Relight") || name.startsWith("Tone")) {
            return "Tool-Relight";
        }
        if (name.startsWith("Red Eyes")) {
            return "Tool-Red-Eye";
        }
        return null;
    }
}

