/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation.generic;

import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.operation.generic.ConfiguredBoundedRangeModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

class ConfiguredTextField
extends JTextField
implements MouseWheelListener,
ChangeListener,
DocumentListener {
    private static final FocusListener FocusSelector = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent event) {
            ConfiguredTextField text = (ConfiguredTextField)event.getSource();
            text.selectAll();
            text.addMouseWheelListener(text);
        }

        @Override
        public void focusLost(FocusEvent event) {
            ConfiguredTextField text = (ConfiguredTextField)event.getSource();
            text.select(0, 0);
            text.removeMouseWheelListener(text);
        }
    };
    private ConfiguredBoundedRangeModel model;
    private NumberFormat format;
    private double min;
    private double max;
    private double inc;
    private boolean isUpdating;

    ConfiguredTextField(ConfiguredBoundedRangeModel model, DecimalFormat format) {
        this.model = model;
        this.format = format;
        this.min = model.getConfiguredMinimum();
        this.max = model.getConfiguredMaximum();
        this.inc = model.getConfiguredIncrement();
        this.setInputVerifier(new IntervalVerifier(this.min, this.max));
        this.setHorizontalAlignment(4);
        this.setFont(this.getFont());
        this.addListeners();
        this.updateFromModel();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.model == null) {
            return;
        }
        double max = this.model.getConfiguredMaximum();
        int widest = ConfiguredTextField.getWidestNumber(max);
        String tempText = Integer.toString(widest);
        int places = this.format.getMaximumFractionDigits();
        if (places > 0) {
            tempText = tempText + ".";
            for (int n = 0; n < places; ++n) {
                tempText = tempText + "0";
            }
        }
        String text = this.getText();
        this.setText(tempText);
        this.setPreferredSize(null);
        Dimension size = this.getPreferredSize();
        this.setText(text);
        this.setMinimumSize(size);
        this.setPreferredSize(size);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (this.isUpdating) {
            return;
        }
        Object source = event.getSource();
        if (!source.equals(this.model)) {
            return;
        }
        this.updateFromModel();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.handleDocumentChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.handleDocumentChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.handleDocumentChange();
    }

    private void updateFromModel() {
        double value = this.model.getConfiguredValue();
        String text = this.format.format(value);
        if (!text.equals(this.getText())) {
            this.setText(text);
            this.selectAll();
        }
    }

    private void handleDocumentChange() {
        InputVerifier verifier = this.getInputVerifier();
        String text = this.getText();
        boolean verified = verifier.verify(this);
        if (!verified) {
            this.setForeground(Color.red);
        } else {
            try {
                double value = this.format.parse(text).doubleValue();
                this.setForeground(LightZoneSkin.Colors.ToolPanesForeground);
                this.isUpdating = true;
                this.model.setConfiguredValue(value);
                this.isUpdating = false;
            }
            catch (ParseException e) {
                System.err.println("Unparsable verified text: " + text);
                this.setForeground(Color.red);
            }
        }
    }

    private void addListeners() {
        Document doc = this.getDocument();
        doc.addDocumentListener(this);
        this.model.addChangeListener(this);
        this.addFocusListener(FocusSelector);
        InputMap input = this.getInputMap(0);
        KeyStroke space = KeyStroke.getKeyStroke(new Character(' '), 0);
        input.put(space, "none");
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                double value = ConfiguredTextField.this.model.getConfiguredValue();
                if ((value = ConfiguredTextField.this.getNextRoundValueUp(value)) >= ConfiguredTextField.this.min && value <= ConfiguredTextField.this.max) {
                    ConfiguredTextField.this.model.setConfiguredValue(value);
                }
            }
        }, KeyStroke.getKeyStroke(38, 0), 0);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                double value = ConfiguredTextField.this.model.getConfiguredValue();
                if ((value = ConfiguredTextField.this.getNextRoundValueDown(value)) >= ConfiguredTextField.this.min && value <= ConfiguredTextField.this.max) {
                    ConfiguredTextField.this.model.setConfiguredValue(value);
                }
            }
        }, KeyStroke.getKeyStroke(40, 0), 0);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        double value = this.model.getConfiguredValue();
        int count = event.getWheelRotation();
        int sign = count > 0 ? 1 : -1;
        for (int n = 0; n < sign * count && (value = sign > 0 ? this.getNextRoundValueDown(value) : this.getNextRoundValueUp(value)) >= this.min && value <= this.max; ++n) {
            this.model.setConfiguredValue(value);
        }
    }

    private double getNextRoundValueDown(double value) {
        return this.getRoundValue(value - this.inc);
    }

    private double getNextRoundValueUp(double value) {
        return this.getRoundValue(value + this.inc);
    }

    private double getRoundValue(double value) {
        return this.inc * (double)Math.round(value / this.inc);
    }

    private static int getWidestNumber(double max) {
        double powTen = Math.pow(10.0, Math.ceil(Math.log(max) / Math.log(10.0)));
        int widest = (int)Math.round(powTen);
        if (widest == 1) {
            widest = 100;
        }
        return widest;
    }

    private class IntervalVerifier
    extends InputVerifier {
        private double min;
        private double max;

        IntervalVerifier(double min, double max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public boolean verify(JComponent input) {
            double x;
            JTextField textField = (JTextField)input;
            String text = textField.getText();
            try {
                x = ConfiguredTextField.this.format.parse(text).doubleValue();
            }
            catch (ParseException e) {
                return false;
            }
            return x >= this.min && x <= this.max;
        }
    }
}

