/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation.drag;

import com.lightcrafts.ui.operation.drag.DraggableStack;
import com.lightcrafts.ui.operation.drag.StackableComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;

class StackLayer
extends JPanel {
    private DraggableStack draggableStack;
    private JComponent dragComp;
    private JComponent placeholderComp;
    private boolean isDragSwappable;

    StackLayer(DraggableStack draggableStack) {
        this.draggableStack = draggableStack;
        this.setLayout(null);
        this.setOpaque(false);
    }

    void setDragComponent(JComponent comp, boolean isSwappable) {
        if (this.dragComp == comp) {
            return;
        }
        if (comp != null) {
            this.placeholderComp = new JPanel();
            this.placeholderComp.setOpaque(false);
            Dimension size = comp.getPreferredSize();
            this.placeholderComp.setPreferredSize(size);
            int index = this.getIndexOf(comp);
            this.remove(comp);
            this.add((Component)this.placeholderComp, index);
        } else {
            int index = this.getIndexOf(this.placeholderComp);
            this.remove(this.placeholderComp);
            this.add((Component)this.dragComp, index);
            this.placeholderComp = null;
        }
        this.dragComp = comp;
        this.isDragSwappable = isSwappable;
        this.validate();
        this.repaint();
    }

    @Override
    public void doLayout() {
        Dimension size = this.getSize();
        Component[] comps = this.getComponents();
        if (comps.length == 0) {
            return;
        }
        int y = 0;
        int midX = size.width / 2;
        for (int n = comps.length - 1; n >= 0; --n) {
            Component comp = comps[n];
            Dimension pref = comp.getPreferredSize();
            int width = pref.width;
            int height = pref.height;
            int x = midX - width / 2;
            if (x < 0) {
                x = 0;
                width = size.width;
            }
            comp.setLocation(x, y);
            comp.setSize(width, height);
            y += height;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Component[] comps = this.getComponents();
        int width = 0;
        int height = 0;
        for (int n = 0; n < comps.length; ++n) {
            Component comp = comps[n];
            Dimension pref = comp.getPreferredSize();
            width = Math.max(width, pref.width);
            height += pref.height;
        }
        return new Dimension(width, height);
    }

    void dragTo(int dragTop) {
        if (!this.isDragSwappable) {
            return;
        }
        int index = this.getIndexOf(this.placeholderComp);
        Rectangle phBounds = this.placeholderComp.getBounds();
        int phTop = phBounds.y;
        int dragBottom = dragTop + phBounds.height;
        if (dragTop <= phTop) {
            if (index < this.getComponentCount() - 1) {
                Component upper = this.getComponent(index + 1);
                if (!((StackableComponent)((Object)upper)).isSwappable()) {
                    return;
                }
                int upperMidY = upper.getY() + upper.getHeight() / 2;
                if (dragTop < upperMidY) {
                    this.remove(this.placeholderComp);
                    this.remove(upper);
                    this.add(upper, index);
                    this.add((Component)this.placeholderComp, index + 1);
                    this.notifySwap(index);
                }
            }
        } else if (index > 0) {
            Component lower = this.getComponent(index - 1);
            if (!((StackableComponent)((Object)lower)).isSwappable()) {
                return;
            }
            int lowerMidY = lower.getY() + lower.getHeight() / 2;
            if (dragBottom > lowerMidY) {
                this.remove(lower);
                this.remove(this.placeholderComp);
                this.add((Component)this.placeholderComp, index - 1);
                this.add(lower, index);
                this.notifySwap(index - 1);
            }
        }
    }

    private void notifySwap(int index) {
        this.draggableStack.swapOccurred(index);
        this.validate();
        this.repaint();
    }

    private int getIndexOf(Component comp) {
        Component[] comps = this.getComponents();
        for (int n = 0; n < comps.length; ++n) {
            if (comp != comps[n]) continue;
            return n;
        }
        return -1;
    }
}

