/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation.colorbalance;

import com.lightcrafts.ui.operation.colorbalance.ColorWheel;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputListener;

abstract class ColorWheelMouseListener
implements MouseInputListener {
    private ColorWheel wheel;

    ColorWheelMouseListener(ColorWheel wheel) {
        this.wheel = wheel;
    }

    abstract void colorPicked(Color var1, boolean var2);

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.updatePicked(e, true);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.updatePicked(e, false);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.updatePicked(e, true);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private void updatePicked(MouseEvent event, boolean isChanging) {
        Point p = event.getPoint();
        Color color = this.wheel.pointToColor(p, false);
        this.wheel.pickColor(color);
        this.colorPicked(color, isChanging);
    }
}

