/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation.colorbalance;

import com.lightcrafts.model.ColorPickerOperation;
import com.lightcrafts.model.Operation;
import com.lightcrafts.ui.layout.Box;
import com.lightcrafts.ui.operation.OpStack;
import com.lightcrafts.ui.operation.colorbalance.ColorText;
import com.lightcrafts.ui.operation.colorbalance.ColorWheel;
import com.lightcrafts.ui.operation.colorbalance.ColorWheelMouseListener;
import com.lightcrafts.ui.operation.colorbalance.Locale;
import com.lightcrafts.ui.operation.generic.GenericControl;
import com.lightcrafts.ui.swing.ColorSwatch;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.Color;
import java.awt.Component;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class ColorPickerControl
extends GenericControl {
    private ColorSwatch swatch;
    private ColorText text;
    private ColorWheel wheel;
    protected Box colorContent;
    private boolean wasChanging;
    private boolean isColorWheelUpdating;
    private static final String ColorTag = "Color";

    public ColorPickerControl(ColorPickerOperation op, OpStack stack) {
        super(op, stack);
    }

    @Override
    protected void operationChanged(Operation operation) {
        super.operationChanged(operation);
        Color color = ((ColorPickerOperation)operation).getColor();
        this.swatch = new ColorSwatch(color);
        this.text = new ColorText(color);
        this.wheel = new ColorWheel();
        ColorWheelMouseListener listener = new ColorWheelMouseListener(this.wheel){

            @Override
            void colorPicked(Color color, boolean isChanging) {
                color = ColorPickerControl.this.getAdjustedWheelColor();
                ColorPickerControl.this.setColor(color, isChanging);
            }
        };
        this.wheel.addMouseListener(listener);
        this.wheel.addMouseMotionListener(listener);
        this.colorContent = Box.createHorizontalBox();
        this.colorContent.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.colorContent.add(this.wheel);
        this.colorContent.add(Box.createHorizontalStrut(8));
        this.colorContent.add(this.swatch);
        this.colorContent.add(Box.createHorizontalStrut(8));
        this.colorContent.add(this.text);
        this.colorContent.add(Box.createHorizontalStrut(8));
        JComponent content = this.getContent();
        content.add((Component)this.colorContent, 0);
        content.add(Box.createVerticalStrut(8), 0);
    }

    private void setColor(Color color, boolean isChanging) {
        Operation op;
        if (isChanging && !this.wasChanging) {
            op = this.getOperation();
            op.changeBatchStarted();
        } else if (this.wasChanging && !isChanging) {
            op = this.getOperation();
            op.changeBatchEnded();
        }
        this.wasChanging = isChanging;
        op = (ColorPickerOperation)this.getOperation();
        Map<String, Double> map = op.setColor(color);
        this.updateColor(map);
        if (!this.undoSupport.isRestoring() && !isChanging) {
            this.undoSupport.postEdit(Locale.LOCALE.get("SetColorEditName"));
        }
    }

    private Color getColor() {
        return ((ColorPickerOperation)this.getOperation()).getColor();
    }

    protected void updateColor(Map<String, Double> sliders) {
        for (String key : sliders.keySet()) {
            double value = sliders.get(key);
            this.slewSlider(key, value);
        }
        Color color = this.getColor();
        this.swatch.setColor(color);
        this.text.setColor(color);
        if (!this.isColorWheelUpdating) {
            this.isColorWheelUpdating = true;
            this.wheel.pickColor(color);
            this.isColorWheelUpdating = false;
        }
    }

    private Color getAdjustedWheelColor() {
        Color wheelColor = this.wheel.getPickedColor();
        Color opColor = ((ColorPickerOperation)this.getOperation()).getColor();
        float[] wheelHsb = Color.RGBtoHSB(wheelColor.getRed(), wheelColor.getGreen(), wheelColor.getBlue(), null);
        float[] opHsb = Color.RGBtoHSB(opColor.getRed(), opColor.getGreen(), opColor.getBlue(), null);
        int rgb = Color.HSBtoRGB(wheelHsb[0], wheelHsb[1], opHsb[2]);
        return new Color(rgb);
    }

    @Override
    public void save(XmlNode node) {
        super.save(node);
        Color color = this.getColor();
        XmlNode colorNode = node.addChild(ColorTag);
        colorNode.setAttribute("r", Integer.toString(color.getRed()));
        colorNode.setAttribute("g", Integer.toString(color.getGreen()));
        colorNode.setAttribute("b", Integer.toString(color.getBlue()));
    }

    @Override
    public void restore(XmlNode node) throws XMLException {
        super.restore(node);
        XmlNode whiteNode = node.getChild(ColorTag);
        int r = Integer.parseInt(whiteNode.getAttribute("r"));
        int g = Integer.parseInt(whiteNode.getAttribute("g"));
        int b = Integer.parseInt(whiteNode.getAttribute("b"));
        Color color = new Color(r, g, b);
        this.undoSupport.restoreStart();
        this.setColor(color, false);
        this.undoSupport.restoreEnd();
    }

    @Override
    protected String getHelpTopic() {
        return "Tool-Black_and_White";
    }
}

