/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation;

import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.operation.SelectableTitle;
import com.lightcrafts.ui.operation.drag.StackableComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class SelectableControl
extends JLayeredPane
implements StackableComponent {
    public static final Color Background = LightZoneSkin.Colors.ToolsBackground;
    public static final Font ControlFont = LightZoneSkin.fontSet.getSmallFont();
    private static final Border ControlBorder;
    private static final Border SelectedBorder;
    private static final int TitleHeight = 24;
    SelectableTitle title;
    JComponent content;
    boolean isContentVisible;

    public SelectableControl() {
        this.setBackground(Background);
        this.title = new SelectableTitle(this);
        this.title.setBackground(Background);
        this.title.setFont(ControlFont);
        this.add(this.title);
        this.setContent(new JLabel("Default Control"));
        this.setShowContent(true);
        this.setOpaque(false);
        this.setFont(ControlFont);
        this.setBorder(ControlBorder);
        this.setTitle("Default Control");
        this.enableEvents(16L);
    }

    public ComboFrame getComboFrame() {
        return (ComboFrame)SwingUtilities.getAncestorOfClass(ComboFrame.class, this);
    }

    @Override
    public boolean isFocusCycleRoot() {
        return true;
    }

    public void setTitle(String s) {
        this.title.setTitleText(s);
    }

    @Override
    public JComponent getDraggableComponent() {
        return this.title;
    }

    @Override
    public boolean isSwappable() {
        return false;
    }

    void setShowContent(boolean visible) {
        if (this.isContentVisible != visible) {
            this.isContentVisible = visible;
            if (visible) {
                this.add(this.content);
            } else {
                this.remove(this.content);
            }
            this.revalidate();
        }
    }

    boolean isContentShown() {
        return this.isContentVisible;
    }

    protected void setContent(JComponent c) {
        if (this.isContentVisible) {
            this.remove(this.content);
        }
        this.content = c;
        if (this.isContentVisible) {
            this.add(this.content);
            this.content.setBackground(Background);
            this.content.setFont(ControlFont);
        }
    }

    protected JComponent getContent() {
        return this.content;
    }

    public void setRegionIndicator(boolean hasRegion) {
        this.title.setRegionIndicator(hasRegion);
    }

    void setSelected(boolean selected) {
        this.title.setSelected(selected);
        if (selected) {
            this.setBorder(SelectedBorder);
        } else {
            this.setBorder(ControlBorder);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Insets insets = this.getInsets();
        Dimension size = this.getSize();
        Color oldColor = g.getColor();
        g.setColor(Background);
        g.fillRect(insets.left, insets.top, size.width - insets.right - insets.left, size.height - insets.bottom - insets.top);
        g.setColor(oldColor);
    }

    @Override
    public Dimension getPreferredSize() {
        int height = 24;
        if (this.isContentVisible) {
            Dimension contentSize = this.content.getPreferredSize();
            height += contentSize.height;
            ++height;
        }
        Insets insets = this.getInsets();
        return new Dimension(Integer.MAX_VALUE, height += insets.top + insets.bottom);
    }

    @Override
    public void doLayout() {
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        int minX = insets.left;
        int maxX = size.width - insets.right;
        int minY = insets.top;
        int maxY = size.height - insets.bottom;
        int width = maxX - minX;
        int height = maxY - minY;
        this.title.setLocation(minX, minY);
        this.title.setSize(width, 24);
        if (!this.isContentVisible) {
            return;
        }
        Dimension contentSize = this.content.getPreferredSize();
        int x = Math.max((width - contentSize.width) / 2, 0) + minX;
        int y = minY + 24 + 1;
        int h = height - 24 - 1;
        int w = Math.min(contentSize.width, width);
        this.content.setLocation(x, y);
        this.content.setSize(w, h);
    }

    protected String getHelpTopic() {
        return null;
    }

    static {
        Border thinPadding = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        Border thickPadding = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        Border selectedBorder = BorderFactory.createLineBorder(LightZoneSkin.Colors.SelectedToolBorder, 2);
        Border unselectedBorder = BorderFactory.createLineBorder(Color.darkGray, 1);
        SelectedBorder = BorderFactory.createCompoundBorder(thinPadding, selectedBorder);
        ControlBorder = BorderFactory.createCompoundBorder(thickPadding, unselectedBorder);
    }
}

