/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation;

import com.lightcrafts.ui.operation.OpControl;
import com.lightcrafts.ui.operation.OpTitle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.border.Border;

class OpTitleEditor
extends MouseAdapter {
    private static final Border on = BorderFactory.createLineBorder(Color.lightGray);
    private static final Border off = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private OpTitle title;
    private JTextField label;
    private boolean isEditing;
    private OpControl.OpControlUndoSupport undo;

    OpTitleEditor(OpTitle title, OpControl.OpControlUndoSupport undo) {
        this.title = title;
        this.undo = undo;
    }

    void setLabel(JTextField label) {
        if (this.label != null) {
            this.label.removeMouseListener(this);
        }
        this.label = label;
        if (label != null) {
            label.addMouseListener(this);
            label.setBorder(off);
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.label.setBorder(on);
        this.label.repaint();
    }

    @Override
    public void mouseExited(MouseEvent event) {
        this.label.setBorder(off);
        this.label.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (event.getClickCount() != 2) {
            return;
        }
        final JTextField editor = new JTextField();
        final String oldText = this.label.getText();
        editor.setText(oldText);
        Border border = BorderFactory.createLineBorder(Color.gray);
        editor.setBorder(border);
        Dimension size = editor.getPreferredSize();
        editor.setPreferredSize(new Dimension(145, size.height));
        editor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent event) {
                if (OpTitleEditor.this.isEditing) {
                    final String text = editor.getText();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            OpTitleEditor.this.title.resetTitle(text);
                            OpTitleEditor.this.undo.postEdit("Change Tool Name");
                        }
                    });
                }
            }
        });
        editor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (OpTitleEditor.this.isEditing) {
                    final String text = editor.getText();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            OpTitleEditor.this.title.resetTitle(text);
                            OpTitleEditor.this.undo.postEdit("Change Tool Name");
                            OpTitleEditor.this.isEditing = false;
                        }
                    });
                }
            }
        });
        editor.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (OpTitleEditor.this.isEditing && e.getKeyCode() == 27) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            OpTitleEditor.this.title.resetTitle(oldText);
                            OpTitleEditor.this.isEditing = false;
                        }
                    });
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                OpTitleEditor.this.title.setTitle(editor);
                editor.requestFocusInWindow();
                OpTitleEditor.this.isEditing = true;
            }
        });
    }
}

