/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation;

import com.lightcrafts.model.Operation;
import com.lightcrafts.ui.mode.Mode;
import com.lightcrafts.ui.operation.Locale;
import com.lightcrafts.ui.operation.LockedOverlay;
import com.lightcrafts.ui.operation.OpActions;
import com.lightcrafts.ui.operation.OpControlModeListener;
import com.lightcrafts.ui.operation.OpFooter;
import com.lightcrafts.ui.operation.OpStack;
import com.lightcrafts.ui.operation.OpTitle;
import com.lightcrafts.ui.operation.SelectableControl;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlDocument;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEditSupport;

public abstract class OpControl
extends SelectableControl {
    protected OpControlUndoSupport undoSupport;
    private Operation operation;
    private boolean isActive;
    private boolean isLocked;
    private LockedOverlay lockOver;
    private OpFooter footer;
    private OpControlEdit currentEdit;
    private List<OpControlModeListener> modeListeners;
    private static final String ActiveTag = "Active";
    private static final String LockedTag = "Locked";

    protected OpControl(Operation operation, OpStack stack) {
        this.operation = operation;
        this.undoSupport = new OpControlUndoSupport();
        this.modeListeners = new LinkedList<OpControlModeListener>();
        this.remove(this.title);
        this.title = new OpTitle(this, stack);
        this.title.setBackground(Background);
        this.title.setFont(ControlFont);
        this.add(this.title);
        this.maybeSetEngineDeactivatable();
        this.isActive = true;
        this.isLocked = false;
        this.lockOver = new LockedOverlay();
        List layerModes = stack.getLayerModes();
        this.footer = new OpFooter(this, layerModes);
        if (this.hasFooter()) {
            this.add(this.footer);
        }
        String name = OpActions.getName(operation);
        if (!this.isSingleton()) {
            name = stack.getNextUniqueName(name);
        }
        this.title.setTitleText(name);
    }

    protected void readyForUndo() {
        this.undoSupport.initialize();
    }

    void setActivated(boolean active) {
        this.operation.setActivated(active);
        ((OpTitle)this.title).setActive(active);
        this.isActive = active;
        if (this.isActive) {
            this.undoSupport.postEdit(Locale.LOCALE.get("EnableEditName") + ' ' + this.title.getTitleText(), true);
        } else {
            this.undoSupport.postEdit(Locale.LOCALE.get("DisableEditName") + ' ' + this.title.getTitleText(), true);
        }
    }

    boolean isActivated() {
        return this.isActive;
    }

    String getTitleText() {
        return this.title.getTitleText();
    }

    public void setLocked(boolean locked) {
        boolean wasLocked = this.isLocked;
        if (locked) {
            this.add((Component)this.lockOver, PALETTE_LAYER);
            this.title.addLock();
        } else {
            this.remove(this.lockOver);
            this.title.removeLock();
            if (!this.isContentVisible) {
                this.title.doExpand();
            }
        }
        this.isLocked = locked;
        if (this.isLocked != wasLocked) {
            if (this.isLocked) {
                this.undoSupport.postEdit(Locale.LOCALE.get("LockEditName") + ' ' + this.title.getTitleText(), false);
            } else {
                this.undoSupport.postEdit(Locale.LOCALE.get("UnlockEditName") + ' ' + this.title.getTitleText(), false);
            }
            this.title.findOpStack().notifyLockChanged(this);
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public boolean isSingleton() {
        return this.operation.isSingleton();
    }

    public boolean hasFooter() {
        return this.operation.hasFooter();
    }

    public boolean isRawCorrection() {
        return this.title.getTitleText().startsWith("RAW");
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void addModeListener(OpControlModeListener listener) {
        this.modeListeners.add(listener);
    }

    public void removeModeListener(OpControlModeListener listener) {
        this.modeListeners.remove(listener);
    }

    public void notifyListenersEnterMode(Mode mode) {
        for (OpControlModeListener listener : this.modeListeners) {
            listener.enterMode(mode);
        }
    }

    public void notifyListenersExitMode(Mode mode) {
        for (OpControlModeListener listener : this.modeListeners) {
            listener.exitMode(mode);
        }
    }

    void setRegionInverted(boolean inverted) {
        this.operation.setRegionInverted(inverted);
    }

    protected void operationChanged(Operation operation) {
        this.maybeSetEngineDeactivatable();
        this.footer.operationChanged(operation);
    }

    void setOperation(Operation operation) {
        Class<?> newClass;
        Class<?> oldClass = this.operation.getClass();
        if (!oldClass.equals(newClass = operation.getClass())) {
            throw new RuntimeException("Incompatible Operation change: was " + oldClass + ", is " + newClass);
        }
        this.operation = operation;
        operation.setActivated(this.isActive);
        this.operationChanged(operation);
    }

    void restorePresets(XmlNode presets) throws XMLException {
        this.restore(presets);
        this.undoSupport.postEdit(Locale.LOCALE.get("ApplyPresetEditName"));
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.isContentVisible) {
            Point contentLoc = this.content.getLocation();
            Dimension contentSize = this.content.getSize();
            Dimension layerSize = !this.isSingleton() && this.hasFooter() ? this.footer.getPreferredSize() : new Dimension();
            contentSize.height -= layerSize.height;
            this.content.setSize(contentSize);
            Dimension size = this.getSize();
            Insets insets = this.getInsets();
            int minX = insets.left;
            int maxX = size.width - insets.right;
            if (!this.isSingleton() && this.hasFooter()) {
                this.footer.setLocation(minX, contentLoc.y + contentSize.height);
                this.footer.setSize(maxX - minX, layerSize.height);
            }
            if (this.isLocked) {
                Rectangle lockBounds = new Rectangle(insets.left, contentLoc.y, maxX - minX, contentSize.height + layerSize.height);
                this.lockOver.setBounds(lockBounds);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.isContentVisible && !this.isSingleton() && this.hasFooter()) {
            size.height += this.footer.getPreferredSize().height;
        }
        return size;
    }

    @Override
    public boolean isSwappable() {
        return !this.operation.isSingleton();
    }

    public void save(XmlNode node) {
        this.footer.save(node);
        this.title.save(node);
        node.setAttribute(ActiveTag, Boolean.toString(this.isActive));
        node.setAttribute(LockedTag, Boolean.toString(this.isLocked));
    }

    public void restore(XmlNode node) throws XMLException {
        boolean locked;
        this.undoSupport.restoreStart();
        this.footer.restore(node);
        this.title.restore(node);
        this.maybeSetEngineDeactivatable();
        if (node.hasAttribute(ActiveTag)) {
            boolean active = Boolean.valueOf(node.getAttribute(ActiveTag));
            this.setActivated(active);
        }
        if (node.hasAttribute(LockedTag) && (locked = Boolean.valueOf(node.getAttribute(LockedTag)).booleanValue())) {
            this.setLocked(locked);
        }
        this.undoSupport.restoreEnd();
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        this.undoSupport.addUndoableEditListener(listener);
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.undoSupport.removeUndoableEditListener(listener);
    }

    private void maybeSetEngineDeactivatable() {
        if (this.isRawCorrection() || this.isSingleton()) {
            this.operation.setEngineDeActivatable(false);
        }
    }

    private final class OpControlEdit
    extends AbstractUndoableEdit {
        private XmlDocument beforeDoc = new XmlDocument("before");
        private XmlDocument afterDoc = new XmlDocument("after");
        private String name;
        private boolean isSignificant = true;

        private OpControlEdit() {
            OpControl.this.save(this.beforeDoc.getRoot());
        }

        private void end(String name) {
            this.name = name;
            OpControl.this.save(this.afterDoc.getRoot());
        }

        private void setSignificance(boolean significant) {
            this.isSignificant = significant;
        }

        @Override
        public String getPresentationName() {
            return this.name;
        }

        @Override
        public boolean isSignificant() {
            return this.isSignificant;
        }

        @Override
        public void undo() {
            super.undo();
            try {
                OpControl.this.restore(this.beforeDoc.getRoot());
            }
            catch (XMLException e) {
                CannotUndoException cue = new CannotUndoException();
                cue.initCause(e);
                throw cue;
            }
            OpControl.this.currentEdit = new OpControlEdit();
        }

        @Override
        public void redo() {
            super.redo();
            try {
                OpControl.this.restore(this.afterDoc.getRoot());
            }
            catch (XMLException e) {
                CannotRedoException cre = new CannotRedoException();
                cre.initCause(e);
                throw cre;
            }
            OpControl.this.currentEdit = new OpControlEdit();
        }
    }

    public class OpControlUndoSupport
    extends UndoableEditSupport {
        private boolean restoring;

        public void initialize() {
            OpControl.this.currentEdit = new OpControlEdit();
        }

        public void postEdit(String name, boolean significant) {
            if (!this.restoring && OpControl.this.currentEdit != null) {
                OpControl.this.currentEdit.end(name);
                OpControl.this.currentEdit.setSignificance(significant);
                this.postEdit(OpControl.this.currentEdit);
                OpControl.this.currentEdit = new OpControlEdit();
            }
        }

        public void postEdit(String name) {
            if (!this.restoring && OpControl.this.currentEdit != null) {
                OpControl.this.currentEdit.end(name);
                this.postEdit(OpControl.this.currentEdit);
                OpControl.this.currentEdit = new OpControlEdit();
            }
        }

        public void restoreStart() {
            this.restoring = true;
        }

        public void restoreEnd() {
            this.restoring = false;
        }

        public boolean isRestoring() {
            return this.restoring;
        }
    }
}

