/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation;

import com.lightcrafts.model.Engine;
import com.lightcrafts.model.Operation;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.ui.operation.OpStack;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;

public class OpActions {
    public static final String IconImageKey = "IconImageKey";
    private static final String OpKeyPropertyKey = "OpKey";
    private static final List<String> OpKeys;
    private static final ResourceBundle Resources;
    private static Comparator<Action> OpComparator;
    private List<Action> actions = new LinkedList<Action>();

    OpActions(Engine engine, final OpStack stack) {
        String key = "ZoneMapper";
        String name = OpActions.getName(key);
        BufferedImage image = OpActions.getImage(key);
        ImageIcon icon = new ImageIcon(image);
        String tooltip = Resources.getString(key + "_Tooltip");
        AbstractAction action = new AbstractAction(name, icon){

            @Override
            public void actionPerformed(ActionEvent event) {
                stack.addZoneControl();
            }
        };
        action.putValue(IconImageKey, image);
        action.putValue("ShortDescription", tooltip);
        action.putValue(OpKeyPropertyKey, key);
        this.actions.add(action);
        key = "Clone";
        name = OpActions.getName(key);
        image = OpActions.getImage(key);
        icon = new ImageIcon(image);
        tooltip = Resources.getString(key + "_Tooltip");
        action = new AbstractAction(name, icon){

            @Override
            public void actionPerformed(ActionEvent event) {
                stack.addCloneControl();
            }
        };
        action.putValue(IconImageKey, image);
        action.putValue("ShortDescription", tooltip);
        action.putValue(OpKeyPropertyKey, key);
        this.actions.add(action);
        key = "Spot";
        name = OpActions.getName(key);
        image = OpActions.getImage(key);
        icon = new ImageIcon(image);
        tooltip = Resources.getString(key + "_Tooltip");
        action = new AbstractAction(name, icon){

            @Override
            public void actionPerformed(ActionEvent event) {
                stack.addSpotControl();
            }
        };
        action.putValue(IconImageKey, image);
        action.putValue("ShortDescription", tooltip);
        action.putValue(OpKeyPropertyKey, key);
        this.actions.add(action);
        Collection<OperationType> types = engine.getGenericOperationTypes();
        for (final OperationType type : types) {
            key = OpActions.getOperationKey(type);
            int index = OpKeys.indexOf(key);
            if (index < 0) continue;
            name = OpActions.getName(type);
            image = OpActions.getImage(key);
            icon = new ImageIcon(image);
            tooltip = this.getToolTip(key);
            action = new AbstractAction(name, icon){

                @Override
                public void actionPerformed(ActionEvent event) {
                    stack.addGenericControl(type);
                }
            };
            action.putValue(IconImageKey, image);
            action.putValue("ShortDescription", tooltip);
            action.putValue(OpKeyPropertyKey, key);
            this.actions.add(action);
        }
        Collections.sort(this.actions, OpComparator);
    }

    static List<Action> createStaticAddActions() {
        LinkedList<Action> actions = new LinkedList<Action>();
        for (String key : OpKeys) {
            String name = OpActions.getName(key);
            BufferedImage image = OpActions.getImage(key);
            ImageIcon icon = new ImageIcon(image);
            String tooltip = Resources.getString(key + "_Tooltip");
            AbstractAction action = new AbstractAction(name, icon){

                @Override
                public void actionPerformed(ActionEvent event) {
                }
            };
            action.putValue(IconImageKey, image);
            action.putValue("ShortDescription", tooltip);
            action.putValue(OpKeyPropertyKey, key);
            action.setEnabled(false);
            actions.add(action);
        }
        return actions;
    }

    List<Action> getActions() {
        return new LinkedList<Action>(this.actions);
    }

    static String getName(Operation op) {
        OperationType type = op.getType();
        return OpActions.getName(type);
    }

    static String getName(OperationType type) {
        String key = OpActions.getOperationKey(type);
        String name = OpActions.getName(key);
        return name != null ? name : type.getName();
    }

    static BufferedImage getIcon(Operation op) {
        OperationType type = op.getType();
        return OpActions.getIcon(type);
    }

    static BufferedImage getIcon(OperationType type) {
        String key = OpActions.getOperationKey(type);
        return OpActions.getImage(key);
    }

    private static String getOperationKey(OperationType type) {
        String key = type.getName();
        key = key.replaceAll(" ", "");
        return key;
    }

    private static String getName(String key) {
        try {
            return Resources.getString(key + "_Name");
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private static BufferedImage getImage(String key) {
        String iconName;
        try {
            iconName = Resources.getString(key + "_Icon");
        }
        catch (MissingResourceException e) {
            iconName = "generic";
        }
        return OpActions.getIconFromResources(iconName);
    }

    private static BufferedImage getIconFromResources(String name) {
        String path = "resources/" + name + ".png";
        URL url = OpActions.class.getResource(path);
        try {
            return ImageIO.read(url);
        }
        catch (IOException e) {
            return null;
        }
    }

    private String getToolTip(String key) {
        try {
            return Resources.getString(key + "_Tooltip");
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    static {
        Resources = ResourceBundle.getBundle("com/lightcrafts/ui/operation/OpActions");
        OpKeys = new LinkedList<String>();
        String names = Resources.getString("Operations");
        StringTokenizer tokens = new StringTokenizer(names, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            OpKeys.add(token);
        }
        OpComparator = new Comparator<Action>(){

            @Override
            public int compare(Action a1, Action a2) {
                String n1 = (String)a1.getValue(OpActions.OpKeyPropertyKey);
                String n2 = (String)a2.getValue(OpActions.OpKeyPropertyKey);
                int i1 = OpKeys.indexOf(n1);
                int i2 = OpKeys.indexOf(n2);
                return i1 - i2;
            }
        };
    }
}

