/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.operation;

import com.lightcrafts.model.LayerConfig;
import com.lightcrafts.model.LayerMode;
import com.lightcrafts.model.Operation;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.layout.Box;
import com.lightcrafts.ui.operation.Locale;
import com.lightcrafts.ui.operation.OpControl;
import com.lightcrafts.ui.toolkit.LCSliderUI;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeSupport;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

final class LayerControls
extends Box {
    private Operation op;
    private JComboBox combo;
    private JSlider slider;
    private List<LayerMode> layerModes;
    private final PropertyChangeSupport pcs;
    public static final String BLENDING_MODES = "Blending Modes";
    private static final String ModeTag = "Mode";
    private static final String OpacityTag = "Opacity";

    LayerControls(OpControl control, List<LayerMode> modes, PropertyChangeSupport pcs) {
        super(0);
        this.setBackground(OpControl.Background);
        this.op = control.getOperation();
        this.layerModes = modes;
        this.pcs = pcs;
        this.combo = new JComboBox();
        this.combo.setBackground(OpControl.Background);
        this.combo.setFont(OpControl.ControlFont);
        this.combo.setMaximumRowCount(30);
        this.combo.setFocusable(false);
        for (LayerMode mode : this.layerModes) {
            this.combo.addItem(mode);
        }
        this.slider = new JSlider();
        this.slider.setFocusable(false);
        this.slider.setBackground(OpControl.Background);
        this.slider.setFont(OpControl.ControlFont);
        this.slider.setPaintTicks(true);
        this.slider.setMajorTickSpacing(50);
        this.slider.setMinorTickSpacing(10);
        this.slider.setToolTipText(Locale.LOCALE.get("OpacityToolTip"));
        this.slider.setUI(new LCSliderUI(this.slider));
        Box blendingModeBox = Box.createHorizontalBox();
        JLabel blendLabel = new JLabel(Locale.LOCALE.get("BlendingModeMenuLabel") + ": ");
        blendLabel.setFont(LightZoneSkin.fontSet.getSmallFont());
        blendingModeBox.add(blendLabel);
        blendingModeBox.add(this.combo);
        Box opacityBox = Box.createHorizontalBox();
        JLabel opacityLabel = new JLabel(Locale.LOCALE.get("ToolOpacitySliderLabel") + ":  ");
        opacityLabel.setFont(LightZoneSkin.fontSet.getSmallFont());
        opacityBox.add(opacityLabel);
        opacityBox.add(this.slider);
        Box combinedBox = Box.createVerticalBox();
        combinedBox.add(blendingModeBox);
        combinedBox.add(opacityBox);
        blendingModeBox.setAlignmentX(0.0f);
        opacityBox.setAlignmentX(0.0f);
        this.add(Box.createHorizontalStrut(5));
        this.add(combinedBox);
        this.add(Box.createHorizontalStrut(5));
        LayerConfig config = this.op.getDefaultLayerConfig();
        this.setMode(config.getMode());
        this.setOpacity(config.getOpacity());
        final OpControl.OpControlUndoSupport undoSupport = control.undoSupport;
        this.combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                LayerControls.this.updateOperation();
                undoSupport.postEdit(Locale.LOCALE.get("BlendEditName"));
            }
        });
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                LayerControls.this.updateOperation();
            }
        });
        this.slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                LayerControls.this.op.changeBatchStarted();
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                LayerControls.this.op.changeBatchEnded();
                undoSupport.postEdit(Locale.LOCALE.get("OpacityEditName"));
            }
        });
    }

    void save(XmlNode node) {
        node.setAttribute(ModeTag, this.getMode().getName());
        int opacity = this.slider.getValue();
        node.setAttribute(OpacityTag, Integer.toString(opacity));
    }

    void restore(XmlNode node) throws XMLException {
        try {
            int value = Integer.parseInt(node.getAttribute(OpacityTag));
            this.slider.setValue(value);
        }
        catch (NumberFormatException e) {
            throw new XMLException("Value at attribute \"Opacity\" is not a number", e);
        }
        String modeName = node.getAttribute(ModeTag);
        for (LayerMode mode : this.layerModes) {
            if (!modeName.equals(mode.getName())) continue;
            this.setMode(mode);
            return;
        }
        throw new XMLException("Value at attribute \"Mode\" is not a valid layer mode");
    }

    void operationChanged(Operation operation) {
        this.op = operation;
        LayerConfig config = this.op.getDefaultLayerConfig();
        this.setMode(config.getMode());
        this.setOpacity(config.getOpacity());
    }

    private double getOpacity() {
        return (double)this.slider.getValue() / 100.0;
    }

    private void setOpacity(double opacity) {
        this.slider.setValue((int)Math.round(100.0 * opacity));
    }

    private LayerMode getMode() {
        return (LayerMode)this.combo.getSelectedItem();
    }

    private void setMode(LayerMode mode) {
        this.combo.setSelectedItem(mode);
    }

    private void updateOperation() {
        LayerMode mode = this.getMode();
        double opacity = this.getOpacity();
        LayerConfig config = new LayerConfig(mode, opacity);
        this.op.setLayerConfig(config);
        if (opacity == 1.0 && mode.getName().equals("Normal")) {
            this.pcs.firePropertyChange(BLENDING_MODES, Boolean.TRUE, Boolean.FALSE);
        } else {
            this.pcs.firePropertyChange(BLENDING_MODES, Boolean.FALSE, Boolean.TRUE);
        }
    }
}

