/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.metadata2;

import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.metadata2.MetadataScroll;
import com.lightcrafts.ui.metadata2.MetadataTableCellRenderer;
import com.lightcrafts.ui.metadata2.MetadataTableModel;
import com.lightcrafts.ui.metadata2.RatingMetadataEntry;
import com.lightcrafts.ui.metadata2.RatingTableCellRenderer;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

class MetadataTable
extends JTable {
    MetadataTable(MetadataTableModel model) {
        super(model);
        this.setBackground(LightZoneSkin.Colors.ToolPanesBackground);
        this.setForeground(LightZoneSkin.Colors.ToolPanesForeground);
        this.setOpaque(true);
        this.setRowSelectionAllowed(false);
        this.setFocusable(false);
        this.setEnabled(false);
        this.getColumnModel().getColumn(0).setMinWidth(90);
        this.getColumnModel().getColumn(0).setMaxWidth(100);
        this.getColumnModel().getColumn(1).setMinWidth(120);
        this.setFont(LightZoneSkin.fontSet.getSmallFont());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(final MouseEvent event) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Point p = event.getPoint();
                        int row = MetadataTable.this.rowAtPoint(p);
                        int col = MetadataTable.this.columnAtPoint(p);
                        MetadataTable.this.editCellAt(row, col);
                        if (MetadataTable.this.editorComp != null) {
                            MetadataTable.this.editorComp.requestFocusInWindow();
                        }
                    }
                });
            }
        });
        final DefaultCellEditor editor = (DefaultCellEditor)this.getDefaultEditor(Object.class);
        final JTextField editComp = (JTextField)editor.getComponent();
        editComp.setForeground(LightZoneSkin.Colors.ToolPanesForeground);
        editComp.setFont(LightZoneSkin.fontSet.getSmallFont());
        editComp.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent event) {
                editComp.selectAll();
            }
        });
        AbstractAction selectNext = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        editor.stopCellEditing();
                    }
                });
            }
        };
        editComp.registerKeyboardAction(selectNext, KeyStroke.getKeyStroke(9, 0), 0);
        JComboBox<String> ratingCombo = new JComboBox<String>();
        ratingCombo.setEditable(false);
        for (int rating = 0; rating <= 5; ++rating) {
            String item = "";
            for (int n = 1; n <= rating; ++n) {
                item = item + "\u2605";
            }
            ratingCombo.addItem(item);
        }
        ratingCombo.setForeground(LightZoneSkin.Colors.ToolPanesForeground);
        ratingCombo.setFont(RatingTableCellRenderer.RatingFont);
        DefaultCellEditor ratingEditor = new DefaultCellEditor(ratingCombo);
        final JComboBox ratingComp = (JComboBox)ratingEditor.getComponent();
        ratingComp.setForeground(LightZoneSkin.Colors.ToolPanesForeground);
        ratingComp.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent event) {
                ratingComp.setPopupVisible(true);
            }
        });
        this.setDefaultEditor(RatingMetadataEntry.RatingObject.class, ratingEditor);
        MetadataTableCellRenderer renderer = new MetadataTableCellRenderer();
        this.setDefaultRenderer(Object.class, renderer);
        RatingTableCellRenderer ratingRenderer = new RatingTableCellRenderer();
        this.setDefaultRenderer(RatingMetadataEntry.RatingObject.class, ratingRenderer);
        this.setShowGrid(false);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int col) {
        Object o = this.getValueAt(row, col);
        return this.getDefaultRenderer(o.getClass());
    }

    @Override
    public TableCellEditor getCellEditor(int row, int col) {
        Object o = this.getValueAt(row, col);
        return this.getDefaultEditor(o.getClass());
    }

    @Override
    public void editingStopped(ChangeEvent event) {
        super.editingStopped(event);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MetadataScroll scroll = (MetadataScroll)SwingUtilities.getAncestorOfClass(MetadataScroll.class, MetadataTable.this);
                if (scroll != null) {
                    scroll.refresh();
                }
            }
        });
    }
}

