/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.metadata2;

import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.metadata2.DefaultButtons;
import com.lightcrafts.ui.metadata2.Locale;
import com.lightcrafts.ui.metadata2.MetadataPresentation;
import com.lightcrafts.ui.metadata2.MetadataSection;
import com.lightcrafts.ui.metadata2.MetadataTable;
import com.lightcrafts.ui.metadata2.MetadataTableModel;
import com.lightcrafts.ui.toolkit.PaneTitle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.Scrollable;
import javax.swing.table.TableCellEditor;

public class MetadataStack
extends JPanel
implements Scrollable {
    private List<MetadataTable> tables = new LinkedList<MetadataTable>();
    private boolean error;

    public MetadataStack(ImageInfo info) {
        this.setImage(info);
        this.setBackground(LightZoneSkin.Colors.ToolPanesBackground);
        this.setOpaque(true);
    }

    public void setImage(ImageInfo info) {
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        this.tables.clear();
        this.add(new PaneTitle(Locale.LOCALE.get("MetadataTitle")));
        ImageMetadata meta = null;
        try {
            meta = info.getMetadata();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (meta == null) {
            String no = Locale.LOCALE.get("NoLabel");
            JLabel label = new JLabel(no);
            label.setAlignmentX(0.5f);
            this.add(Box.createVerticalGlue());
            this.add(label);
            this.add(Box.createVerticalGlue());
            this.error = true;
            return;
        }
        Collection<ImageMetadataDirectory> directories = meta.getDirectories();
        if (directories.isEmpty()) {
            String empty = Locale.LOCALE.get("EmptyLabel");
            JLabel label = new JLabel(empty);
            label.setAlignmentX(0.5f);
            this.add(Box.createVerticalGlue());
            this.add(label);
            this.add(Box.createVerticalGlue());
            this.error = true;
            return;
        }
        this.error = false;
        MetadataPresentation present = new MetadataPresentation();
        List<MetadataSection> sections = present.getSections();
        Iterator<MetadataSection> i = sections.iterator();
        while (i.hasNext()) {
            MetadataSection section = i.next();
            MetadataTableModel model = new MetadataTableModel(info, meta, section);
            MetadataTable table = new MetadataTable(model);
            this.tables.add(table);
            DefaultButtons buttons = new DefaultButtons(table, meta);
            Box control = Box.createHorizontalBox();
            control.add(table);
            control.add(buttons);
            this.add(control);
            if (!i.hasNext()) continue;
            this.add(Box.createVerticalStrut(4));
            this.add(new JSeparator());
            this.add(Box.createVerticalStrut(4));
        }
        this.add(Box.createVerticalStrut(4));
        this.add(new JSeparator());
        this.add(Box.createVerticalGlue());
    }

    boolean isEditing() {
        for (MetadataTable table : this.tables) {
            if (!table.isEditing()) continue;
            return true;
        }
        return false;
    }

    void endEditing() {
        for (MetadataTable table : this.tables) {
            if (!table.isEditing()) continue;
            TableCellEditor editor = table.getCellEditor();
            editor.stopCellEditing();
        }
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        Component[] comps;
        for (Component comp : comps = this.getComponents()) {
            if (!(comp instanceof JTable)) continue;
            JTable table = (JTable)comp;
            return table.getScrollableBlockIncrement(visibleRect, orientation, direction);
        }
        return 1;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        Component[] comps;
        for (Component comp : comps = this.getComponents()) {
            if (!(comp instanceof JTable)) continue;
            JTable table = (JTable)comp;
            return table.getScrollableUnitIncrement(visibleRect, orientation, direction);
        }
        return 1;
    }
}

