/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.metadata2;

import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.prefs.ApplicationMode;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.metadata2.Locale;
import com.lightcrafts.ui.metadata2.MetadataEntry;
import com.lightcrafts.ui.metadata2.MetadataTable;
import com.lightcrafts.ui.metadata2.MetadataTableModel;
import com.lightcrafts.ui.toolkit.CoolButton;
import com.lightcrafts.ui.toolkit.IconFactory;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;

class DefaultButtons
extends JPanel {
    private static final Icon icon = IconFactory.createInvertedIcon(DefaultButtons.class, "left_arrow.png", 12);
    private static final Dimension ButtonSize;
    private MetadataTable table;
    private ImageMetadata meta;
    private Map<MetadataEntry, JButton> buttons;

    DefaultButtons(MetadataTable table, ImageMetadata meta) {
        this.table = table;
        this.meta = meta;
        this.setBackground(LightZoneSkin.Colors.ToolPanesBackground);
        this.setOpaque(true);
        this.setLayout(null);
        this.initButtons();
        this.updateButtons();
        table.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                DefaultButtons.this.updateButtons();
                DefaultButtons.this.repaint();
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(DefaultButtons.ButtonSize.width, this.table.getPreferredSize().height);
    }

    private void initButtons() {
        this.buttons = new HashMap<MetadataEntry, JButton>();
        final MetadataTableModel model = (MetadataTableModel)this.table.getModel();
        for (int row = 0; row < model.getRowCount(); ++row) {
            final MetadataEntry entry = model.getEntryAt(row);
            if (!entry.hasDefaultValue()) continue;
            CoolButton button = new CoolButton();
            ((AbstractButton)button).setIcon(icon);
            button.setToolTipText(Locale.LOCALE.get("DefaultButtonToolTip"));
            this.buttons.put(entry, button);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    entry.setDefaultValue(DefaultButtons.this.meta);
                    model.commit();
                    DefaultButtons.this.table.repaint();
                }
            });
            this.add(button);
            button.setEnabled(!ApplicationMode.isBasicMode());
            ApplicationMode.maybeSetToolTip(button);
        }
    }

    private void updateButtons() {
        MetadataTableModel model = (MetadataTableModel)this.table.getModel();
        int rowHeight = this.table.getRowHeight();
        for (int row = 0; row < model.getRowCount(); ++row) {
            MetadataEntry entry = model.getEntryAt(row);
            if (!entry.hasDefaultValue()) continue;
            JButton button = this.buttons.get(entry);
            Dimension buttonSize = button.getPreferredSize();
            button.setSize(buttonSize);
            button.setEnabled(!ApplicationMode.isBasicMode() && entry.hasDefaultValue());
            int y = row * rowHeight + rowHeight / 2 - buttonSize.height / 2;
            button.setLocation(0, y);
        }
    }

    static {
        CoolButton button = new CoolButton();
        button.setIcon(icon);
        ButtonSize = button.getPreferredSize();
    }
}

