/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.metadata;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.metadata.CIFFDirectory;
import com.lightcrafts.image.metadata.CoreDirectory;
import com.lightcrafts.image.metadata.EXIFDirectory;
import com.lightcrafts.image.metadata.IPTCDirectory;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.TIFFDirectory;
import com.lightcrafts.image.metadata.makernotes.MakerNotesDirectory;
import com.lightcrafts.ui.metadata.DirectoryLabel;
import com.lightcrafts.ui.metadata.MetadataTable;
import com.lightcrafts.ui.metadata.MetadataTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.Scrollable;

public class DirectoryStack
extends JPanel
implements Scrollable {
    private static ResourceBundle Resources = ResourceBundle.getBundle("com/lightcrafts/ui/metadata/resources/Directories");
    private Map<ImageMetadataDirectory, MetadataTable> tables;
    private boolean showIDs;
    private boolean error;
    private Set<Class<? extends ImageMetadataDirectory>> expandedDirectories = new HashSet<Class<? extends ImageMetadataDirectory>>();
    private boolean filter;
    private boolean sort;

    public DirectoryStack(ImageMetadata metadata) {
        this(metadata, true, true, false);
    }

    public DirectoryStack(ImageMetadata metadata, boolean filter, boolean sort, boolean showIDs) {
        this.showIDs = showIDs;
        this.filter = filter;
        this.sort = sort;
        this.expandedDirectories.add(CoreDirectory.class);
        this.setMetadata(metadata);
    }

    public void setMetadata(ImageMetadata metadata) {
        Class[] middles;
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        if (metadata == null) {
            String no = Resources.getString("NoLabel");
            JLabel label = new JLabel(no);
            label.setAlignmentX(0.5f);
            this.add(Box.createVerticalGlue());
            this.add(label);
            this.add(Box.createVerticalGlue());
            this.error = true;
            return;
        }
        Collection<ImageMetadataDirectory> directories = metadata.getDirectories();
        if (directories.isEmpty()) {
            String empty = Resources.getString("EmptyLabel");
            JLabel label = new JLabel(empty);
            label.setAlignmentX(0.5f);
            this.add(Box.createVerticalGlue());
            this.add(label);
            this.add(Box.createVerticalGlue());
            this.error = true;
            return;
        }
        if (this.tables != null) {
            this.disposeTables();
        }
        this.tables = new HashMap<ImageMetadataDirectory, MetadataTable>();
        ImageMetadataDirectory dir = metadata.getDirectoryFor(CoreDirectory.class);
        if (dir != null) {
            this.addTableExpanded(dir, false, this.sort);
        }
        for (Class clazz : middles = new Class[]{TIFFDirectory.class, EXIFDirectory.class, CIFFDirectory.class, IPTCDirectory.class}) {
            dir = metadata.getDirectoryFor(clazz);
            if (dir == null) continue;
            this.addTable(dir, this.filter, this.sort);
        }
        for (ImageMetadataDirectory maker : directories) {
            if (!(maker instanceof MakerNotesDirectory)) continue;
            this.addTable(maker, this.filter, this.sort);
        }
        for (ImageMetadataDirectory imd : directories) {
            if (this.tables.containsKey(imd)) continue;
            this.addTable(imd, this.filter, this.sort);
        }
    }

    boolean isDirectoryExpanded(ImageMetadataDirectory dir) {
        return this.expandedDirectories.contains(dir.getClass());
    }

    void expandDirectory(ImageMetadataDirectory dir) {
        this.expandedDirectories.add(dir.getClass());
    }

    void collapseDirectory(ImageMetadataDirectory dir) {
        this.expandedDirectories.remove(dir.getClass());
    }

    void showDirectory(ImageMetadataDirectory dir) {
        MetadataTable table = this.tables.get(dir);
        table.setPreferredSize(null);
        this.revalidate();
    }

    void hideDirectory(ImageMetadataDirectory dir) {
        MetadataTable table = this.tables.get(dir);
        table.setPreferredSize(new Dimension(0, 0));
        this.revalidate();
    }

    private void addTable(ImageMetadataDirectory dir, boolean filter, boolean sort) {
        if (!this.tables.isEmpty()) {
            this.add(new JSeparator());
        }
        String name = this.getDirName(dir);
        MetadataTableModel model = new MetadataTableModel(dir, filter, sort, this.showIDs);
        MetadataTable table = new MetadataTable(model);
        this.tables.put(dir, table);
        DirectoryLabel label = new DirectoryLabel(dir, name, this);
        this.add(label);
        this.add(table);
    }

    private void addTableExpanded(ImageMetadataDirectory dir, boolean filter, boolean sort) {
        if (!this.tables.isEmpty()) {
            this.add(new JSeparator());
        }
        String name = this.getDirName(dir);
        MetadataTableModel model = new MetadataTableModel(dir, filter, sort, this.showIDs);
        MetadataTable table = new MetadataTable(model);
        this.tables.put(dir, table);
        DirectoryLabel label = new DirectoryLabel(dir, name, this);
        this.add(label);
        this.add(table);
    }

    private String getDirName(ImageMetadataDirectory dir) {
        try {
            return Resources.getString(dir.getName() + "Name");
        }
        catch (MissingResourceException e) {
            return dir.getName();
        }
    }

    public void disposeTables() {
        Collection<MetadataTable> values = this.tables.values();
        for (MetadataTable table : values) {
            table.dispose();
        }
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.error;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        Component[] comps;
        for (Component comp : comps = this.getComponents()) {
            if (!(comp instanceof JTable)) continue;
            JTable table = (JTable)comp;
            return table.getScrollableBlockIncrement(visibleRect, orientation, direction);
        }
        return 1;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        Component[] comps;
        for (Component comp : comps = this.getComponents()) {
            if (!(comp instanceof JTable)) continue;
            JTable table = (JTable)comp;
            return table.getScrollableUnitIncrement(visibleRect, orientation, direction);
        }
        return 1;
    }

    public static void main(String[] args) throws IOException, BadImageFileException, UnknownImageTypeException {
        if (args.length != 1) {
            System.err.println("usage: DirectoryStack (file)");
            System.exit(1);
        }
        File file = new File(args[0]);
        ImageInfo info = ImageInfo.getInstanceFor(file);
        ImageMetadata metadata = info.getMetadata();
        DirectoryStack dirs = new DirectoryStack(metadata, true, true, true);
        JScrollPane panel = new JScrollPane(dirs);
        JFrame frame = new JFrame("Test");
        frame.setContentPane(panel);
        frame.setDefaultCloseOperation(3);
        frame.setLocation(100, 100);
        frame.pack();
        frame.setVisible(true);
    }
}

