/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.layout;

import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.layout.FadingTabbedPanel;
import com.lightcrafts.ui.toolkit.CoolToggleButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JPanel;

class VerticalToggleButton
extends CoolToggleButton {
    VerticalToggleButton(String text, FadingTabbedPanel.Orientation orient) {
        RotatedTextIcon icon = new RotatedTextIcon(orient, text);
        this.setIcon(icon);
        Dimension preferredSize = this.getPreferredSize();
        preferredSize.height = 100;
        this.setPreferredSize(preferredSize);
    }

    public static void main(String[] args) {
        VerticalToggleButton up = new VerticalToggleButton("hello", FadingTabbedPanel.Orientation.Up);
        VerticalToggleButton down = new VerticalToggleButton("world", FadingTabbedPanel.Orientation.Down);
        JPanel panel = new JPanel();
        panel.setOpaque(true);
        panel.setBackground(LightZoneSkin.Colors.ToolPanesBackground);
        panel.add(up);
        panel.add(down);
        JFrame frame = new JFrame("VerticalToggleButton");
        frame.setContentPane(panel);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    class RotatedTextIcon
    implements Icon {
        private FadingTabbedPanel.Orientation orient;
        private GlyphVector glyphs;
        private float width;
        private float height;
        private float ascent;

        RotatedTextIcon(FadingTabbedPanel.Orientation orient, String text) {
            this.orient = orient;
            Font font = VerticalToggleButton.this.getFont();
            FontRenderContext fcr = new FontRenderContext(null, true, true);
            this.glyphs = font.createGlyphVector(fcr, text);
            this.width = (int)this.glyphs.getLogicalBounds().getWidth() + 4;
            this.height = (int)this.glyphs.getLogicalBounds().getHeight();
            LineMetrics lineMetrics = font.getLineMetrics(text, fcr);
            this.ascent = lineMetrics.getAscent();
            this.height = (int)lineMetrics.getHeight();
        }

        @Override
        public int getIconWidth() {
            return (int)this.height;
        }

        @Override
        public int getIconHeight() {
            return (int)this.width;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            Font font = VerticalToggleButton.this.getFont();
            g2d.setFont(font);
            AffineTransform oldTransform = g2d.getTransform();
            g2d.setColor(c.getForeground());
            AffineTransform trans = new AffineTransform();
            switch (this.orient) {
                case Up: {
                    trans.concatenate(oldTransform);
                    trans.translate(x, y - 2);
                    trans.rotate(4.71238898038469, this.height / 2.0f, this.width / 2.0f);
                    g2d.setTransform(trans);
                    g2d.drawGlyphVector(this.glyphs, (this.height - this.width) / 2.0f, (this.width - this.height) / 2.0f + this.ascent);
                    break;
                }
                case Down: {
                    trans.concatenate(oldTransform);
                    trans.translate(x, y + 2);
                    trans.rotate(1.5707963267948966, this.height / 2.0f, this.width / 2.0f);
                    g2d.setTransform(trans);
                    g2d.drawGlyphVector(this.glyphs, (this.height - this.width) / 2.0f, (this.width - this.height) / 2.0f + this.ascent);
                }
            }
            g2d.setTransform(oldTransform);
        }
    }
}

