/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.layout;

import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.layout.Box;
import com.lightcrafts.ui.layout.FadingTabConfiguration;
import com.lightcrafts.ui.layout.FadingTabbedPanelListener;
import com.lightcrafts.ui.layout.VerticalToggleButton;
import com.lightcrafts.ui.toolkit.FadingContainer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class FadingTabbedPanel
extends JPanel {
    private static final Color FadeAwayColor = LightZoneSkin.Colors.FrameBackground;
    private Map<String, FadingTabConfiguration> confs;
    private Collection<JToggleButton> buttons;
    private JToggleButton selected;
    private FadingTabbedPanelListener panelListener;
    private Box buttonBox;

    public FadingTabbedPanel(FadingTabConfiguration conf, Orientation orient, FadingTabbedPanelListener panelListener) {
        this(Collections.singletonList(conf), orient, panelListener);
    }

    public JComponent getButtonContainer() {
        return this.buttonBox;
    }

    public String getSelected() {
        return this.selected != null ? this.selected.getName() : null;
    }

    public void setSelected(String name) {
        for (JToggleButton button : this.buttons) {
            if (!button.getName().equals(name)) continue;
            button.setSelected(true);
        }
    }

    public FadingTabbedPanel(List<FadingTabConfiguration> confs, Orientation orient, FadingTabbedPanelListener panelListener) {
        this.panelListener = panelListener;
        this.buttons = new LinkedList<JToggleButton>();
        this.buttonBox = Box.createVerticalBox();
        TabListener tabListener = new TabListener();
        this.confs = new HashMap<String, FadingTabConfiguration>();
        for (FadingTabConfiguration conf : confs) {
            this.confs.put(conf.name, conf);
            VerticalToggleButton button = new VerticalToggleButton(conf.name, orient);
            button.setToolTipText(conf.tip);
            button.setAlignmentY(0.5f);
            button.setName(conf.name);
            button.addItemListener(tabListener);
            this.buttons.add(button);
            this.buttonBox.add(button);
        }
        this.buttonBox.add(Box.createVerticalGlue());
        this.setLayout(new BorderLayout());
    }

    class TabListener
    implements ItemListener {
        private FadingContainer fader;
        boolean isDeselecting;

        TabListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            JToggleButton button = (JToggleButton)event.getSource();
            String name = button.getName();
            if (event.getStateChange() == 1) {
                JComponent comp = ((FadingTabConfiguration)((FadingTabbedPanel)FadingTabbedPanel.this).confs.get((Object)name)).comp;
                if (this.fader == null) {
                    this.fader = new FadingContainer(FadeAwayColor);
                    FadingTabbedPanel.this.add(this.fader);
                    FadingTabbedPanel.this.panelListener.somethingSelected();
                    FadingTabbedPanel.this.validate();
                }
                this.fader.nextComponent(comp, null);
                if (FadingTabbedPanel.this.selected != null) {
                    this.isDeselecting = true;
                    FadingTabbedPanel.this.selected.setSelected(false);
                    this.isDeselecting = false;
                }
                FadingTabbedPanel.this.selected = button;
                FadingTabbedPanel.this.panelListener.tabSelected(name);
            } else if (!this.isDeselecting) {
                this.fader.nextComponent(FadeAwayColor, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        FadingTabbedPanel.this.panelListener.nothingSelected();
                        FadingTabbedPanel.this.remove(TabListener.this.fader);
                        TabListener.this.fader = null;
                    }
                });
                FadingTabbedPanel.this.selected = null;
            }
        }
    }

    public static enum Orientation {
        Up,
        Down;

    }
}

