/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.layout;

import com.lightcrafts.ui.layout.BoxLayout;
import java.awt.AWTError;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;

public class Box
extends JComponent
implements Accessible {
    protected AccessibleContext accessibleContext = null;

    public Box(int axis) {
        super.setLayout(new BoxLayout(this, axis));
    }

    public static Box createHorizontalBox() {
        return new Box(0);
    }

    public static Box createVerticalBox() {
        return new Box(1);
    }

    public static Component createRigidArea(Dimension d) {
        return new Filler(d, d, d);
    }

    public static Component createHorizontalStrut(int width) {
        return new Filler(new Dimension(width, 0), new Dimension(width, 0), new Dimension(width, Short.MAX_VALUE));
    }

    public static Component createVerticalStrut(int height) {
        return new Filler(new Dimension(0, height), new Dimension(0, height), new Dimension(Short.MAX_VALUE, height));
    }

    public static Component createGlue() {
        return new Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
    }

    public static Component createHorizontalGlue() {
        return new Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
    }

    public static Component createVerticalGlue() {
        return new Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
    }

    @Override
    public void setLayout(LayoutManager l) {
        throw new AWTError("Illegal request");
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleBox();
        }
        return this.accessibleContext;
    }

    protected class AccessibleBox
    extends Container.AccessibleAWTContainer {
        protected AccessibleBox() {
            super(Box.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.FILLER;
        }
    }

    public static class Filler
    extends JComponent
    implements Accessible {
        private Dimension reqMin;
        private Dimension reqPref;
        private Dimension reqMax;
        protected AccessibleContext accessibleContext = null;

        public Filler(Dimension min, Dimension pref, Dimension max) {
            this.reqMin = min;
            this.reqPref = pref;
            this.reqMax = max;
        }

        public void changeShape(Dimension min, Dimension pref, Dimension max) {
            this.reqMin = min;
            this.reqPref = pref;
            this.reqMax = max;
            this.invalidate();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.reqMin;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.reqPref;
        }

        @Override
        public Dimension getMaximumSize() {
            return this.reqMax;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleBoxFiller();
            }
            return this.accessibleContext;
        }

        protected class AccessibleBoxFiller
        extends Component.AccessibleAWTComponent {
            protected AccessibleBoxFiller() {
                super(Filler.this);
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.FILLER;
            }
        }
    }
}

