/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.export;

import com.lightcrafts.image.export.ImageExportOptions;
import com.lightcrafts.image.export.ImageFileExportOptions;
import com.lightcrafts.image.types.JPEGImageType;
import com.lightcrafts.image.types.MultipageTIFFImageType;
import com.lightcrafts.image.types.TIFFImageType;
import com.lightcrafts.ui.export.ExportLogic;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlDocument;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;

public class SaveOptions {
    private Lzn lzn;
    private SidecarTiff sideTiff;
    private SidecarJpeg sideJpeg;
    private MultilayerTiff multiTiff;
    private Options options;
    private static final Preferences Prefs = Preferences.userNodeForPackage(SaveOptions.class);
    private static final String SaveOptionsKey = "SaveOptions";

    public static SaveOptions createLzn() {
        return SaveOptions.createLzn(null);
    }

    public static SaveOptions createSidecarTiff() {
        return SaveOptions.createSidecarTiff(TIFFImageType.INSTANCE.newExportOptions());
    }

    public static SaveOptions createSidecarJpeg() {
        return SaveOptions.createSidecarJpeg(JPEGImageType.INSTANCE.newExportOptions());
    }

    public static SaveOptions createMultilayerTiff() {
        return SaveOptions.createMultilayerTiff(MultipageTIFFImageType.INSTANCE.newExportOptions());
    }

    public static SaveOptions createLzn(File file) {
        SaveOptions settings = new SaveOptions();
        settings.lzn = new Lzn(file);
        settings.options = settings.lzn;
        return settings;
    }

    public static SaveOptions createSidecarTiff(ImageExportOptions options) {
        ((TIFFImageType.ExportOptions)options).multilayer.setValue(false);
        SaveOptions settings = new SaveOptions();
        settings.sideTiff = new SidecarTiff(options);
        settings.options = settings.sideTiff;
        return settings;
    }

    public static SaveOptions createSidecarJpeg(ImageExportOptions options) {
        SaveOptions settings = new SaveOptions();
        settings.sideJpeg = new SidecarJpeg(options);
        settings.options = settings.sideJpeg;
        return settings;
    }

    public static SaveOptions createMultilayerTiff(ImageExportOptions options) {
        ((TIFFImageType.ExportOptions)options).multilayer.setValue(true);
        SaveOptions settings = new SaveOptions();
        settings.multiTiff = new MultilayerTiff(options);
        settings.options = settings.multiTiff;
        return settings;
    }

    public static SaveOptions getDefaultSaveOptions() {
        String text = Prefs.get(SaveOptionsKey, null);
        if (text != null && text != null) {
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(text.getBytes("UTF-8"));
                XmlDocument doc = new XmlDocument(in);
                XmlNode root = doc.getRoot();
                SaveOptions options = SaveOptions.restore(root);
                return options;
            }
            catch (Exception e) {
                e.printStackTrace();
                Prefs.remove(SaveOptionsKey);
            }
        }
        SaveOptions options = SaveOptions.createSidecarJpeg();
        ImageFileExportOptions export = (ImageFileExportOptions)SaveOptions.getExportOptions(options);
        export.resizeWidth.setValue(1024);
        export.resizeHeight.setValue(1024);
        return options;
    }

    public static void setDefaultSaveOptions(SaveOptions options) {
        XmlDocument doc = new XmlDocument(SaveOptionsKey);
        XmlNode root = doc.getRoot();
        options.save(root);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            doc.write(out);
            String text = out.toString("UTF-8");
            Prefs.put(SaveOptionsKey, text);
        }
        catch (IOException e) {
            e.printStackTrace();
            Prefs.remove(SaveOptionsKey);
        }
    }

    private SaveOptions() {
    }

    public static ImageExportOptions getExportOptions(SaveOptions options) {
        if (options.isSidecarTiff()) {
            SidecarTiff export = options.getSidecarTiff();
            return export.getExportOptions();
        }
        if (options.isSidecarJpeg()) {
            SidecarJpeg export = options.getSidecarJpeg();
            return export.getExportOptions();
        }
        if (options.isMultilayerTiff()) {
            MultilayerTiff export = options.getMultilayerTiff();
            return export.getExportOptions();
        }
        return null;
    }

    public void setShouldSaveDirectly(boolean b) {
        this.options.m_shouldSaveDirectly = b;
    }

    public boolean shouldSaveDirectly() {
        return this.options.m_shouldSaveDirectly;
    }

    public void updateSize(Dimension size) {
        ImageExportOptions export = SaveOptions.getExportOptions(this);
        if (export != null) {
            ExportLogic.maybeUpdateSize(export, size);
        }
    }

    public void save(XmlNode node) {
        if (this.lzn != null) {
            this.lzn.save(node);
        }
        if (this.sideTiff != null) {
            this.sideTiff.save(node);
        }
        if (this.sideJpeg != null) {
            this.sideJpeg.save(node);
        }
        if (this.multiTiff != null) {
            this.multiTiff.save(node);
        }
    }

    public static SaveOptions restore(XmlNode node) throws XMLException {
        SaveOptions settings = new SaveOptions();
        try {
            settings.lzn = Lzn.restore(node);
            settings.options = settings.lzn;
            return settings;
        }
        catch (XMLException e) {
            try {
                settings.sideTiff = SidecarTiff.restore(node);
                settings.options = settings.sideTiff;
                return settings;
            }
            catch (XMLException e2) {
                try {
                    settings.sideJpeg = SidecarJpeg.restore(node);
                    settings.options = settings.sideJpeg;
                    return settings;
                }
                catch (XMLException e3) {
                    try {
                        settings.multiTiff = MultilayerTiff.restore(node);
                        settings.options = settings.multiTiff;
                        return settings;
                    }
                    catch (XMLException xMLException) {
                        throw new XMLException("No valid SaveOptions data");
                    }
                }
            }
        }
    }

    public boolean isLzn() {
        return this.lzn != null;
    }

    public boolean isSidecarTiff() {
        return this.sideTiff != null;
    }

    public boolean isSidecarJpeg() {
        return this.sideJpeg != null;
    }

    public boolean isMultilayerTiff() {
        return this.multiTiff != null;
    }

    public Lzn getLzn() {
        return this.lzn;
    }

    public SidecarTiff getSidecarTiff() {
        return this.sideTiff;
    }

    public SidecarJpeg getSidecarJpeg() {
        return this.sideJpeg;
    }

    public MultilayerTiff getMultilayerTiff() {
        return this.multiTiff;
    }

    public File getFile() {
        return this.options.getFile();
    }

    public void setFile(File file) {
        this.options.setFile(file);
    }

    String getName() {
        return this.options.getName();
    }

    String getSuffix() {
        return this.options.getSuffix();
    }

    boolean matchesType(SaveOptions other) {
        return this.options.getClass().equals(other.options.getClass());
    }

    public static class MultilayerTiff
    extends Options {
        private ImageExportOptions export;

        MultilayerTiff(ImageExportOptions export) {
            this.export = export;
        }

        public ImageExportOptions getExportOptions() {
            return this.export;
        }

        @Override
        File getFile() {
            return this.export.getExportFile();
        }

        @Override
        void setFile(File file) {
            this.export.setExportFile(file);
        }

        @Override
        String getName() {
            return "TIFF (multilayer)";
        }

        @Override
        String getSuffix() {
            return "tif";
        }

        void save(XmlNode node) {
            this.saveMarker(node);
            this.export.write(node);
        }

        static MultilayerTiff restore(XmlNode node) throws XMLException {
            ImageExportOptions export = ImageExportOptions.read(node);
            MultilayerTiff tiff = new MultilayerTiff(export);
            tiff.verifyMarker(node);
            return tiff;
        }
    }

    public static class SidecarJpeg
    extends Options {
        private ImageExportOptions export;

        SidecarJpeg(ImageExportOptions export) {
            this.export = export;
        }

        public ImageExportOptions getExportOptions() {
            return this.export;
        }

        @Override
        File getFile() {
            return this.export.getExportFile();
        }

        @Override
        void setFile(File file) {
            this.export.setExportFile(file);
        }

        @Override
        String getName() {
            return "JPEG (sidecar)";
        }

        @Override
        String getSuffix() {
            return "jpg";
        }

        void save(XmlNode node) {
            this.saveMarker(node);
            this.export.write(node);
        }

        static SidecarJpeg restore(XmlNode node) throws XMLException {
            ImageExportOptions export = ImageExportOptions.read(node);
            SidecarJpeg jpeg = new SidecarJpeg(export);
            jpeg.verifyMarker(node);
            return jpeg;
        }
    }

    public static class SidecarTiff
    extends Options {
        private ImageExportOptions export;

        SidecarTiff(ImageExportOptions export) {
            this.export = export;
        }

        public ImageExportOptions getExportOptions() {
            return this.export;
        }

        @Override
        File getFile() {
            return this.export.getExportFile();
        }

        @Override
        void setFile(File file) {
            this.export.setExportFile(file);
        }

        @Override
        String getName() {
            return "TIFF (sidecar)";
        }

        @Override
        String getSuffix() {
            return "tif";
        }

        void save(XmlNode node) {
            this.saveMarker(node);
            this.export.write(node);
        }

        static SidecarTiff restore(XmlNode node) throws XMLException {
            ImageExportOptions export = ImageExportOptions.read(node);
            SidecarTiff tiff = new SidecarTiff(export);
            tiff.verifyMarker(node);
            return tiff;
        }
    }

    public static class Lzn
    extends Options {
        private File file;

        Lzn(File file) {
            this.file = file;
        }

        @Override
        File getFile() {
            return this.file;
        }

        @Override
        void setFile(File file) {
            this.file = file;
        }

        @Override
        String getName() {
            return "LZN";
        }

        @Override
        String getSuffix() {
            return "lzn";
        }

        void save(XmlNode node) {
            this.saveMarker(node);
            String path = this.file.getAbsolutePath();
            node.setAttribute("path", path);
        }

        static Lzn restore(XmlNode node) throws XMLException {
            String path = node.getAttribute("path");
            File file = new File(path);
            Lzn lzn = new Lzn(file);
            lzn.verifyMarker(node);
            return lzn;
        }
    }

    static abstract class Options {
        protected boolean m_shouldSaveDirectly;

        Options() {
        }

        abstract File getFile();

        abstract void setFile(File var1);

        abstract String getName();

        abstract String getSuffix();

        void saveMarker(XmlNode node) {
            node.setAttribute("type", this.getName());
        }

        void verifyMarker(XmlNode node) throws XMLException {
            if (!node.getAttribute("type").equals(this.getName())) {
                throw new XMLException("Unexpected SaveOptions Options class");
            }
        }
    }
}

