/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.export;

import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.export.BooleanExportOption;
import com.lightcrafts.image.export.ColorProfileOption;
import com.lightcrafts.image.export.ImageExportOptions;
import com.lightcrafts.image.export.ImageFileExportOptions;
import com.lightcrafts.image.export.IntegerExportOption;
import com.lightcrafts.image.export.LZWCompressionOption;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.types.ImageType;
import com.lightcrafts.image.types.RawImageType;
import com.lightcrafts.image.types.TIFFImageType;
import com.lightcrafts.ui.export.ExportNameUtility;
import com.lightcrafts.utils.ColorProfileInfo;
import java.awt.Dimension;
import java.awt.color.ICC_Profile;
import java.io.File;

public class ExportLogic {
    public static ImageExportOptions getDefaultExportOptions(ImageMetadata meta, Dimension size) {
        TIFFImageType.ExportOptions options = TIFFImageType.INSTANCE.newExportOptions();
        File file = meta.getFile();
        options.setExportFile(file);
        ExportLogic.colorProfileFrom(meta, options);
        ExportLogic.resolutionFrom(meta, options);
        ExportLogic.maybeUpdateSize(options, size);
        return options;
    }

    public static ImageExportOptions getDefaultExportOptions(ImageExportOptions recent, ImageMetadata meta, Dimension size) {
        String name = meta.getFile().getName();
        return ExportLogic.getDefaultExportOptions(recent, meta, size, name);
    }

    public static ImageExportOptions getDefaultExportOptions(ImageExportOptions recent, ImageMetadata meta, Dimension size, String name) {
        ImageExportOptions options = recent;
        File recentFile = recent.getExportFile();
        File dir = null;
        if (recentFile != null) {
            dir = recentFile.getParentFile();
        }
        if (dir == null) {
            dir = new File(System.getProperty("user.home"));
        }
        File currentFile = new File(dir, name);
        options.setExportFile(currentFile);
        if (options instanceof ImageFileExportOptions) {
            ExportLogic.colorProfileFrom(meta, (ImageFileExportOptions)options);
            ExportLogic.resolutionFrom(meta, (ImageFileExportOptions)options);
        }
        ExportLogic.maybeUpdateSize(options, size);
        return options;
    }

    public static ImageExportOptions getDefaultExportOptions(ImageExportOptions current, Dimension size) {
        ExportLogic.maybeUpdateSize(current, size);
        return current;
    }

    public static void maybeUpdateSize(ImageExportOptions options, Dimension size) {
        if (options.originalWidth.getValue() != size.width || options.originalHeight.getValue() != size.height) {
            options.originalWidth.setValue(size.width);
            options.originalHeight.setValue(size.height);
            if (options instanceof ImageFileExportOptions) {
                ImageFileExportOptions fileOptions = (ImageFileExportOptions)options;
                fileOptions.resizeWidth.setValue(size.width);
                fileOptions.resizeHeight.setValue(size.height);
            }
        }
    }

    public static void mergeExportOptions(ImageExportOptions oldOptions, ImageExportOptions newOptions) {
        ImageType oldType;
        File file = oldOptions.getExportFile();
        ImageType newType = newOptions.getImageType();
        if (file != null && !file.isDirectory()) {
            file = ExportNameUtility.ensureCompatibleExtension(file, newType);
            newOptions.setExportFile(file);
        }
        if (oldOptions instanceof ImageFileExportOptions && newOptions instanceof ImageFileExportOptions) {
            ImageFileExportOptions oldFileOptions = (ImageFileExportOptions)oldOptions;
            ImageFileExportOptions newFileOptions = (ImageFileExportOptions)newOptions;
            ExportLogic.copyOption(oldFileOptions.originalWidth, newFileOptions.originalWidth);
            ExportLogic.copyOption(oldFileOptions.originalHeight, newFileOptions.originalHeight);
            ExportLogic.copyOption(oldFileOptions.resizeWidth, newFileOptions.resizeWidth);
            ExportLogic.copyOption(oldFileOptions.resizeHeight, newFileOptions.resizeHeight);
            ExportLogic.copyOption(oldFileOptions.colorProfile, newFileOptions.colorProfile);
            ExportLogic.copyOption(oldFileOptions.renderingIntent, newFileOptions.renderingIntent);
            ExportLogic.copyOption(oldFileOptions.blackPointCompensation, newFileOptions.blackPointCompensation);
        }
        if ((oldType = oldOptions.getImageType()) == TIFFImageType.INSTANCE && newType == TIFFImageType.INSTANCE) {
            TIFFImageType.ExportOptions oldTiff = (TIFFImageType.ExportOptions)oldOptions;
            TIFFImageType.ExportOptions newTiff = (TIFFImageType.ExportOptions)newOptions;
            ExportLogic.copyOption(oldTiff.bitsPerChannel, newTiff.bitsPerChannel);
            ExportLogic.copyOption(oldTiff.lzwCompression, newTiff.lzwCompression);
        }
    }

    private static void colorProfileFrom(ImageMetadata meta, ImageFileExportOptions options) {
        if (!(meta.getImageType() instanceof RawImageType)) {
            try {
                ImageInfo info = ImageInfo.getInstanceFor(meta.getFile());
                ICC_Profile profile = info.getImageType().getICCProfile(info);
                String profileName = ColorProfileInfo.getNameOf(profile);
                options.colorProfile.setValue(profileName);
            }
            catch (Throwable t) {
                System.err.println("Error cloning color profile: " + t.getClass().getName());
            }
        }
    }

    private static void resolutionFrom(ImageMetadata metadata, ImageFileExportOptions options) {
        int resolution = (int)metadata.getResolution();
        int resolutionUnit = metadata.getResolutionUnit();
        if (resolution > 0 && resolutionUnit != 1) {
            options.resolution.setValue(resolution);
            options.resolutionUnit.setValue(resolutionUnit);
        }
    }

    private static void copyOption(BooleanExportOption source, BooleanExportOption target) {
        target.setValue(source.getValue());
    }

    private static void copyOption(IntegerExportOption source, IntegerExportOption target) {
        target.setValue(source.getValue());
    }

    private static void copyOption(ColorProfileOption source, ColorProfileOption target) {
        target.setValue(source.getValue());
    }

    private static void copyOption(LZWCompressionOption source, LZWCompressionOption target) {
        target.setValue(source.getValue());
    }
}

