/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.export;

import com.lightcrafts.image.export.ImageExportOptions;
import com.lightcrafts.image.types.ImageType;
import com.lightcrafts.image.types.JPEGImageType;
import com.lightcrafts.image.types.TIFFImageType;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.export.ExportControls;
import com.lightcrafts.ui.export.ExportCtrlToggle;
import com.lightcrafts.ui.export.ExportLogic;
import com.lightcrafts.ui.export.ExportNameUtility;
import com.lightcrafts.ui.export.Locale;
import com.lightcrafts.utils.xml.XmlDocument;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;

public class ExportDialog
extends JFileChooser {
    private JDialog dialog;
    private JComponent controls;
    private JComponent buttons;
    private JButton exportButton;
    private ExportCtrlToggle toggle;
    private Action approveAction;

    ExportDialog(ImageExportOptions options) {
        this.setAcceptAllFileFilterUsed(false);
        this.setApproveButtonText(Locale.LOCALE.get("ExportButton"));
        ExportFilter defaultFilter = null;
        List<ExportFilter> filters = ExportDialog.getAllFilters();
        ImageType defaultType = options.getImageType();
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (event.getPropertyName().equals("fileFilterChanged")) {
                    ExportFilter oldFilter = (ExportFilter)event.getOldValue();
                    ExportFilter newFilter = (ExportFilter)event.getNewValue();
                    ExportDialog.this.fileFilterChanged(oldFilter, newFilter);
                }
            }
        });
        for (ExportFilter filter : filters) {
            ImageExportOptions filterOptions = filter.getExportOptions();
            ImageType filterType = filterOptions.getImageType();
            if (defaultType.equals(filterType)) {
                defaultFilter = filter = new ExportFilter(options);
            }
            this.addChoosableFileFilter(filter);
        }
        File file = options.getExportFile();
        if (file != null) {
            this.setSelectedFile(file);
        }
        if (defaultFilter != null) {
            this.setFileFilter(defaultFilter);
        }
        this.setControlButtonsAreShown(false);
        ActionMap map = SwingUtilities.getUIActionMap(this);
        this.approveAction = map.get("approveSelection");
    }

    @Override
    protected JDialog createDialog(Component parent) {
        this.dialog = super.createDialog(parent);
        this.initButtons();
        this.initKeyboardActions();
        this.fileFilterChanged(null, (ExportFilter)this.getFileFilter());
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(null);
        return this.dialog;
    }

    ImageExportOptions getSelectedExportOptions() {
        ExportFilter filter = (ExportFilter)this.getFileFilter();
        ImageExportOptions options = filter.getExportOptions();
        File file = this.getSelectedFile();
        options.setExportFile(file);
        return options;
    }

    private static List<ExportFilter> getAllFilters() {
        ArrayList<ExportFilter> filters = new ArrayList<ExportFilter>();
        ExportFilter filter = new ExportFilter(TIFFImageType.INSTANCE.newExportOptions());
        filters.add(filter);
        filter = new ExportFilter(JPEGImageType.INSTANCE.newExportOptions());
        filters.add(filter);
        return filters;
    }

    private void fileFilterChanged(ExportFilter oldFilter, ExportFilter newFilter) {
        File file;
        ImageExportOptions newOptions = newFilter.getExportOptions();
        if (this.dialog != null) {
            Container content = this.dialog.getContentPane();
            if (this.controls != null) {
                content.remove(this.controls);
                this.controls.remove(this.buttons);
            }
            if (oldFilter != null) {
                ImageExportOptions oldOptions = oldFilter.getExportOptions();
                ExportLogic.mergeExportOptions(oldOptions, newOptions);
            }
            ExportControls ctrls = new ExportControls(newOptions, true);
            this.toggle = new ExportCtrlToggle(ctrls, this.dialog);
            this.controls = Box.createVerticalBox();
            this.controls.add(this.toggle);
            this.controls.add(this.buttons);
            this.dialog.getRootPane().setDefaultButton(this.exportButton);
            content.add((Component)this.controls, "South");
            this.dialog.pack();
        }
        if ((file = this.getSelectedFile()) != null && !file.isDirectory()) {
            String ext = newFilter.getSuffix();
            file = ExportNameUtility.setFileExtension(file, ext);
            final File uniqFile = ExportNameUtility.ensureNotExists(file);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExportDialog.this.setSelectedFile(null);
                    ExportDialog.this.setSelectedFile(uniqFile);
                }
            });
        }
    }

    private void initButtons() {
        this.exportButton = new JButton(Locale.LOCALE.get("ExportButton"));
        JButton cancelButton = new JButton(Locale.LOCALE.get("CancelButton"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ExportDialog.this.cancelSelection();
            }
        });
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ExportDialog.this.approveSelection();
                ExportDialog.this.approveAction.actionPerformed(null);
            }
        });
        this.buttons = Box.createHorizontalBox();
        this.buttons.add(Box.createHorizontalGlue());
        this.buttons.add(cancelButton);
        this.buttons.add(Box.createHorizontalStrut(6));
        this.buttons.add(this.exportButton);
        Border border = BorderFactory.createEmptyBorder(6, 10, 10, 10);
        this.buttons.setBorder(border);
    }

    private void initKeyboardActions() {
        JComponent content = (JComponent)this.dialog.getContentPane();
        content.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportDialog.this.approveSelection();
                ExportDialog.this.approveAction.actionPerformed(null);
            }
        }, KeyStroke.getKeyStroke(10, 0), 2);
        content.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportDialog.this.cancelSelection();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    public static ImageExportOptions showDialog(ImageExportOptions options, Frame parent) {
        ExportDialog chooser = new ExportDialog(options);
        chooser.setDialogTitle(Locale.LOCALE.get("ExportTitle"));
        int result = chooser.showDialog(parent, Locale.LOCALE.get("ExportButton"));
        if (result != 0) {
            return null;
        }
        options = chooser.getSelectedExportOptions();
        return options;
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(Platform.getPlatform().getLookAndFeel());
        final TIFFImageType.ExportOptions options = TIFFImageType.INSTANCE.newExportOptions();
        options.originalWidth.setValue(400);
        options.originalHeight.setValue(300);
        options.resizeWidth.setValue(400);
        options.resizeHeight.setValue(300);
        File dir = new File(System.getProperty("user.home"));
        File file = new File(dir, "test.tif");
        options.setExportFile(file);
        final XmlDocument doc = new XmlDocument("Root");
        EventQueue.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ImageExportOptions o = ExportDialog.showDialog(options, null);
                if (o != null) {
                    o.write(doc.getRoot());
                } else {
                    System.out.println("cancelled");
                    System.exit(0);
                }
            }
        });
        doc.write(System.out);
        ImageExportOptions.read(doc.getRoot());
        System.exit(0);
    }

    static class ExportFilter
    extends FileFilter {
        private ImageExportOptions exportOptions;

        private ExportFilter(ImageExportOptions exportOptions) {
            this.exportOptions = exportOptions;
        }

        @Override
        public boolean accept(File f) {
            return true;
        }

        @Override
        public String getDescription() {
            return this.exportOptions.getImageType().getName();
        }

        private String getSuffix() {
            return this.exportOptions.getImageType().getExtensions()[0];
        }

        private ImageExportOptions getExportOptions() {
            return this.exportOptions;
        }
    }
}

