/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.export;

import com.lightcrafts.ui.export.ExportControls;
import com.lightcrafts.ui.export.ExportDialog;
import com.lightcrafts.ui.export.Locale;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

class ExportCtrlToggle
extends Box {
    private static Icon CollapsedIcon;
    private static Icon ExpandedIcon;
    private static Icon CollapsedHighlightIcon;
    private static Icon ExpandedHighlightIcon;
    private static final Preferences Prefs;
    private static final String AdvancedOptionsKey = "AdvancedOptions";
    private ExportControls ctrls;
    private Window window;
    private JLabel label;
    private boolean isExpanded;

    ExportCtrlToggle(ExportControls ctrls, Window window) {
        super(1);
        this.ctrls = ctrls;
        this.window = window;
        this.label = new JLabel(Locale.LOCALE.get("AdvancedOptionsLabel"));
        this.label.setAlignmentX(1.0f);
        Box labelBox = Box.createHorizontalBox();
        labelBox.add(this.label);
        labelBox.add(Box.createHorizontalGlue());
        labelBox.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        this.add(labelBox);
        this.isExpanded = Prefs.getBoolean(AdvancedOptionsKey, true);
        if (this.isExpanded) {
            this.label.setIcon(ExpandedIcon);
            this.add(ctrls);
        } else {
            this.label.setIcon(CollapsedIcon);
        }
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                if (ExportCtrlToggle.this.isExpanded) {
                    ExportCtrlToggle.this.doCollapse();
                } else {
                    ExportCtrlToggle.this.doExpand();
                }
            }

            @Override
            public void mouseEntered(MouseEvent event) {
                if (ExportCtrlToggle.this.isExpanded) {
                    ExportCtrlToggle.this.label.setIcon(ExpandedHighlightIcon);
                } else {
                    ExportCtrlToggle.this.label.setIcon(CollapsedHighlightIcon);
                }
            }

            @Override
            public void mouseExited(MouseEvent event) {
                if (ExportCtrlToggle.this.isExpanded) {
                    ExportCtrlToggle.this.label.setIcon(ExpandedIcon);
                } else {
                    ExportCtrlToggle.this.label.setIcon(CollapsedIcon);
                }
            }
        });
    }

    boolean isExpanded() {
        return this.isExpanded;
    }

    void doExpand() {
        this.add(this.ctrls);
        this.label.setIcon(ExpandedIcon);
        if (this.window != null) {
            this.window.pack();
        } else {
            this.revalidate();
            this.getParent().repaint();
        }
        this.isExpanded = true;
        Prefs.putBoolean(AdvancedOptionsKey, this.isExpanded);
    }

    void doCollapse() {
        this.remove(this.ctrls);
        this.label.setIcon(CollapsedIcon);
        if (this.window != null) {
            this.window.pack();
        } else {
            this.revalidate();
            this.getParent().repaint();
        }
        this.isExpanded = false;
        Prefs.putBoolean(AdvancedOptionsKey, this.isExpanded);
    }

    static {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        URL url = ExportCtrlToggle.class.getResource("resources/RightArrow.png");
        Image image = toolkit.createImage(url);
        CollapsedIcon = new ImageIcon(image);
        url = ExportCtrlToggle.class.getResource("resources/DownArrow.png");
        image = toolkit.createImage(url);
        ExpandedIcon = new ImageIcon(image);
        url = ExportCtrlToggle.class.getResource("resources/RightArrowHighlight.png");
        image = toolkit.createImage(url);
        CollapsedHighlightIcon = new ImageIcon(image);
        url = ExportCtrlToggle.class.getResource("resources/DownArrowHighlight.png");
        image = toolkit.createImage(url);
        ExpandedHighlightIcon = new ImageIcon(image);
        Prefs = Preferences.userNodeForPackage(ExportDialog.class);
    }
}

