/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor.assoc;

import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.ui.editor.LightweightDocument;
import com.lightcrafts.ui.editor.assoc.DefaultDocuments;
import com.lightcrafts.ui.editor.assoc.DocumentDatabaseListener;
import com.lightcrafts.ui.editor.assoc.DocumentInterpreter;
import com.lightcrafts.utils.file.FileUtil;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlDocument;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DocumentDatabase {
    private static Set<File> Directories = new LinkedHashSet<File>();
    private static Map<File, Collection<File>> ImagesToDocs = new HashMap<File, Collection<File>>();
    private static List<WeakReference<DocumentDatabaseListener>> Listeners = new LinkedList<WeakReference<DocumentDatabaseListener>>();
    private static Map<String, DocumentInterpreter> Interpreters = new HashMap<String, DocumentInterpreter>();

    private DocumentDatabase() {
    }

    public static void addDocumentInterpreter(DocumentInterpreter interpreter) {
        Collection<String> suffixes = interpreter.getSuffixes();
        for (String suffix : suffixes) {
            Interpreters.put(suffix, interpreter);
        }
    }

    public static File[] findImageFiles(String name) {
        HashSet<File> dirs = new HashSet<File>();
        dirs.addAll(Directories);
        for (File file : ImagesToDocs.keySet()) {
            File imageDir = file.getParentFile();
            if (imageDir == null) continue;
            dirs.add(imageDir);
        }
        ArrayList<File> files = new ArrayList<File>();
        for (File dir : dirs) {
            File file = new File(dir, name);
            if (!file.isFile()) continue;
            files.add(file);
        }
        return files.toArray(new File[0]);
    }

    public static void addListener(DocumentDatabaseListener listener) {
        Listeners.add(new WeakReference<DocumentDatabaseListener>(listener));
    }

    public static void addDocumentFile(File file) {
        if (file.isFile()) {
            File dir = file.getParentFile();
            if (!DocumentDatabase.directoriesContains(dir)) {
                DocumentDatabase.addToDirectories(dir);
            }
            DocumentDatabase.readDirectory(dir);
        }
    }

    private static void addToDirectories(File dir) {
        try {
            dir = dir.getCanonicalFile();
            Directories.add(dir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean directoriesContains(File dir) {
        try {
            dir = dir.getCanonicalFile();
            return Directories.contains(dir);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void addDocumentDirectory(File dir) {
        if (dir.isDirectory()) {
            DocumentDatabase.addToDirectories(dir);
        }
        DocumentDatabase.readDirectory(dir);
    }

    public static void addDocumentDirectoryRecurse(File dir) {
        if (dir.isDirectory()) {
            DocumentDatabase.readRecurse(dir);
        }
    }

    public static void addDirectories(File[] dirs) {
        for (File dir : dirs) {
            DocumentDatabase.addDocumentDirectory(dir);
        }
    }

    public static List<File> getDocumentsForImage(File imageFile) {
        try {
            imageFile = imageFile.getCanonicalFile();
            Collection<File> docs = ImagesToDocs.get(imageFile);
            if (docs == null) {
                docs = new LinkedList<File>();
                ImagesToDocs.put(imageFile, docs);
            }
            return new LinkedList<File>(docs);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public static Collection<File> getAssociatedDocuments(File docFile) {
        try {
            LightweightDocument doc = new LightweightDocument(docFile);
            File imageFile = doc.getImageFile().getCanonicalFile();
            return new LinkedList<File>(ImagesToDocs.get(imageFile));
        }
        catch (IOException iOException) {
            return Collections.emptySet();
        }
    }

    private static void readFile(File file) {
        String suffix = FileUtil.getExtensionOf(file);
        if (suffix == null) {
            return;
        }
        DocumentInterpreter interp = Interpreters.get(suffix);
        if (interp == null) {
            return;
        }
        try {
            file = file.getCanonicalFile();
            File imageFile = interp.getImageFile(file);
            if (imageFile == null) {
                return;
            }
            Collection<File> docs = ImagesToDocs.get(imageFile);
            if (docs == null) {
                docs = new LinkedList<File>();
                ImagesToDocs.put(imageFile, docs);
            }
            if (!docs.contains(file)) {
                docs.add(file);
                DocumentDatabase.notifyListeners(imageFile);
            }
        }
        catch (XMLException e) {
        }
        catch (IOException e) {
            System.err.println("DocDB: can't read " + file.getName() + ": " + e.getMessage());
        }
    }

    private static void readDirectory(File dir) {
        File[] files = FileUtil.listFiles(dir);
        if (files != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                DocumentDatabase.readFile(file);
            }
        }
    }

    private static void notifyListeners(File imageFile) {
        Iterator<WeakReference<DocumentDatabaseListener>> i = Listeners.iterator();
        while (i.hasNext()) {
            WeakReference<DocumentDatabaseListener> ref = i.next();
            DocumentDatabaseListener listener = (DocumentDatabaseListener)ref.get();
            if (listener != null) {
                listener.docFilesChanged(imageFile);
                continue;
            }
            i.remove();
        }
    }

    private static void readRecurse(File file) {
        if (file.isFile()) {
            DocumentDatabase.readFile(file);
        } else if (file.isDirectory()) {
            File[] children;
            if (!DocumentDatabase.directoriesContains(file)) {
                DocumentDatabase.addToDirectories(file);
            }
            if ((children = FileUtil.listFiles(file)) != null) {
                for (File child : children) {
                    DocumentDatabase.readRecurse(child);
                }
            }
        }
    }

    public static XmlDocument getDefaultDocument(ImageMetadata meta) {
        URL url = DefaultDocuments.getDefaultDocumentUrl(meta);
        if (url != null) {
            try {
                InputStream in = url.openStream();
                XmlDocument doc = new XmlDocument(in);
                in.close();
                return doc;
            }
            catch (IOException e) {
                if (DefaultDocuments.Debug) {
                    System.err.print("Error reading default document at " + url + ": ");
                    System.err.println(e.getMessage());
                }
                return null;
            }
        }
        return null;
    }

    static {
        DocumentDatabase.addDocumentInterpreter(new DocumentInterpreter(){

            @Override
            public File getImageFile(File file) throws IOException {
                if (!FileUtil.getExtensionOf(file).equals("lzn")) {
                    return null;
                }
                file = file.getCanonicalFile();
                LightweightDocument doc = new LightweightDocument(file);
                File imageFile = doc.getImageFile().getCanonicalFile();
                return imageFile;
            }

            @Override
            public Collection<String> getSuffixes() {
                return Collections.singleton("lzn");
            }
        });
    }
}

