/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor;

import com.lightcrafts.model.Engine;
import com.lightcrafts.model.PrintSettings;
import com.lightcrafts.model.RenderingIntent;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.editor.Locale;
import com.lightcrafts.ui.operation.SelectableControl;
import com.lightcrafts.ui.toolkit.WidePopupComboBox;
import com.lightcrafts.utils.ColorProfileInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.color.ICC_Profile;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

final class ProofSelectableControl
extends SelectableControl {
    private static Collection PrinterProfiles = Platform.getPlatform().getPrinterProfiles();
    private static Preferences Prefs = Preferences.userRoot().node("/com/lightcrafts/ui/editor");
    private static final String ProofProfileKey = "ProofColorProfile";
    private static final String ProofIntentKey = "ProofRenderingIntent";
    private static final int PreferredComboWidth = 150;
    private PrintSettings settings;
    private Engine engine;
    private JComboBox printerProfile;
    private JComboBox renderingIntent;
    private JPanel content;

    ProofSelectableControl(Engine engine) {
        this.engine = engine;
        this.setTitle(Locale.LOCALE.get("ProofControlTitle"));
        this.settings = new PrintSettings();
        this.initPrinterProfile();
        this.initRenderingIntent();
        this.initContent();
        this.setContent(this.content);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.engine.preview(this.settings);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.engine.preview(null);
    }

    private void initPrinterProfile() {
        this.printerProfile = new WidePopupComboBox();
        this.printerProfile.setFocusable(false);
        List<ColorProfileInfo> profiles = ColorProfileInfo.arrangeForMenu(PrinterProfiles);
        for (ColorProfileInfo profile : profiles) {
            this.printerProfile.addItem(profile);
        }
        String initProfile = Prefs.get(ProofProfileKey, null);
        if (initProfile != null) {
            for (ColorProfileInfo profile : profiles) {
                if (profile == null || !profile.getName().equals(initProfile)) continue;
                this.printerProfile.setSelectedItem(profile);
                this.settings.setColorProfile(profile.getICCProfile());
            }
        }
        this.printerProfile.setMaximumRowCount(25);
        this.printerProfile.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ColorProfileInfo cpi = (ColorProfileInfo)ProofSelectableControl.this.printerProfile.getSelectedItem();
                    ICC_Profile profile = cpi.getICCProfile();
                    ProofSelectableControl.this.settings.setColorProfile(profile);
                    ProofSelectableControl.this.engine.preview(ProofSelectableControl.this.settings);
                    Prefs.put(ProofSelectableControl.ProofProfileKey, cpi.getName());
                }
            }
        });
    }

    private void initRenderingIntent() {
        RenderingIntent[] intents;
        this.renderingIntent = new WidePopupComboBox();
        this.renderingIntent.setFocusable(false);
        for (RenderingIntent intent : intents = RenderingIntent.getAll()) {
            this.renderingIntent.addItem(intent);
        }
        String initIntent = Prefs.get(ProofIntentKey, null);
        if (initIntent != null) {
            for (RenderingIntent intent : intents) {
                if (!intent.toString().equals(initIntent)) continue;
                this.renderingIntent.setSelectedItem(intent);
                this.settings.setRenderingIntent(intent);
            }
        }
        this.renderingIntent.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    RenderingIntent intent = (RenderingIntent)ProofSelectableControl.this.renderingIntent.getSelectedItem();
                    ProofSelectableControl.this.settings.setRenderingIntent(intent);
                    ProofSelectableControl.this.engine.preview(ProofSelectableControl.this.settings);
                    Prefs.put(ProofSelectableControl.ProofIntentKey, intent.toString());
                }
            }
        });
    }

    private void initContent() {
        this.content = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        JLabel profileLabel = new JLabel(Locale.LOCALE.get("ProofProfileLabel") + ": ");
        profileLabel.setMinimumSize(profileLabel.getPreferredSize());
        profileLabel.setFont(this.getFont());
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        c.fill = 0;
        this.content.add((Component)profileLabel, c);
        this.printerProfile.setFont(this.getFont());
        ProofSelectableControl.setFixedSize(this.printerProfile);
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 10;
        c.fill = 2;
        this.content.add((Component)this.printerProfile, c);
        JLabel intentLabel = new JLabel(Locale.LOCALE.get("ProofIntentLabel") + ": ");
        intentLabel.setMinimumSize(intentLabel.getPreferredSize());
        intentLabel.setFont(this.getFont());
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 13;
        c.fill = 0;
        this.content.add((Component)intentLabel, c);
        this.renderingIntent.setFont(this.getFont());
        ProofSelectableControl.setFixedSize(this.renderingIntent);
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 10;
        c.fill = 2;
        this.content.add((Component)this.renderingIntent, c);
        Border border = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        this.content.setBorder(border);
    }

    private static void setFixedSize(JComboBox combo) {
        Dimension size = combo.getPreferredSize();
        size = new Dimension(150, size.height);
        combo.setMinimumSize(size);
        combo.setPreferredSize(size);
        combo.setMaximumSize(size);
    }

    @Override
    protected String getHelpTopic() {
        return "Tool-Proof";
    }
}

