/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor;

import com.lightcrafts.ui.editor.EditorControls;
import com.lightcrafts.ui.editor.Locale;
import com.lightcrafts.ui.editor.ProofSelectableControl;
import com.lightcrafts.ui.toolkit.CoolToggleButton;
import com.lightcrafts.ui.toolkit.IconFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;

class ProofButton
extends CoolToggleButton
implements ItemListener {
    private static Icon Icon = IconFactory.createIcon(ProofButton.class, "proof.png");
    private static final String ShowTip = Locale.LOCALE.get("ShowProofToolTip");
    private static final String HideTip = Locale.LOCALE.get("HideProofToolTip");
    private static final String ShowName = Locale.LOCALE.get("ShowProofActionName");
    private static final String HideName = Locale.LOCALE.get("HideProofActionName");
    private EditorControls editor;
    private ProofSelectableControl control;
    private Action action;

    ProofButton(EditorControls editor, ProofSelectableControl control) {
        this.editor = editor;
        this.control = control;
        this.setIcon(Icon);
        this.setToolTipText(ShowTip);
        this.initAction();
        this.addItemListener(this);
    }

    ProofButton() {
        this.setIcon(Icon);
        this.setToolTipText(ShowTip);
        this.setEnabled(false);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.editor.addControl(this.control);
            this.action.putValue("Name", HideName);
            this.setToolTipText(HideTip);
        } else {
            this.editor.removeControl(this.control);
            this.action.putValue("Name", ShowName);
            this.setToolTipText(ShowTip);
        }
    }

    public Action getShowHideAction() {
        return this.action;
    }

    private void initAction() {
        this.action = new AbstractAction(ShowName){

            @Override
            public void actionPerformed(ActionEvent event) {
                ProofButton.this.setSelected(!ProofButton.this.isSelected());
            }
        };
    }
}

