/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor;

import com.lightcrafts.model.Preview;
import com.lightcrafts.ui.editor.PreviewTabs;
import com.lightcrafts.ui.editor.ToolsContainer;
import com.lightcrafts.ui.operation.OpStack;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

class PreviewSplit
extends JPanel {
    private static final Dimension PreviewSize = new Dimension(280, 190);
    private ToolsContainer tools;
    private JSplitPane split;
    private PreviewTabs tabs;
    private boolean showPreview;

    PreviewSplit(OpStack stack, Preview[] previews) {
        this.tools = new ToolsContainer(stack);
        this.setLayout(new BorderLayout());
        this.add(this.tools);
        this.split = new JSplitPane(0);
        this.split.setContinuousLayout(true);
        this.split.setDividerSize(4);
        this.tabs = new PreviewTabs(previews);
        this.split.add(this.tabs);
        this.setShowPreview(true);
    }

    PreviewSplit() {
        this.tools = new ToolsContainer();
        this.setLayout(new BorderLayout());
        this.add(this.tools);
        this.split = new JSplitPane(0);
        this.split.setContinuousLayout(true);
        this.split.setDividerSize(4);
        this.tabs = new PreviewTabs();
        this.split.add(this.tabs);
        this.setShowPreview(true);
    }

    Preview getPreview() {
        return this.tabs != null ? this.tabs.getPreview() : null;
    }

    boolean isPreviewVisible() {
        return this.showPreview;
    }

    void setPreview(Preview preview) {
        this.tabs.setPreview(preview);
    }

    void setShowPreview(boolean show) {
        if (this.showPreview == show) {
            return;
        }
        this.showPreview = show;
        if (show) {
            this.remove(this.tools);
            this.split.add(this.tools);
            if (this.tabs.isValid()) {
                this.split.setDividerLocation(this.tabs.getSize().height);
            } else {
                this.split.setDividerLocation(PreviewSplit.PreviewSize.height);
            }
            this.add(this.split);
        } else {
            this.split.remove(this.tools);
            this.remove(this.split);
            this.add(this.tools);
        }
        this.revalidate();
    }

    void setDropper(Point p) {
        Preview preview = this.getPreview();
        if (preview != null) {
            preview.setDropper(p);
        }
    }
}

