/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor;

import com.lightcrafts.ui.editor.Locale;
import com.lightcrafts.ui.editor.RelativePathUtility;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlDocument;
import com.lightcrafts.utils.xml.XmlNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LightweightDocument {
    private static final String ImageTag = "Image";
    private static final String PathTag = "path";
    private static final String RelativePathTag = "relativePath";
    private static final Pattern PathsPattern = Pattern.compile(".*<\\s*Image\\s+(?:.*\\s+)?path\\s*=\\s*\"([^\"]*)\"(\\s+(?:.*\\s+)?relativePath\\s*=\\s*\"([^\"]*)\")?.*");
    private File imageFile;
    private File docFile;

    public LightweightDocument(String path) throws IOException, XMLException {
        this(new File(path));
    }

    public LightweightDocument(File file, XmlDocument doc) throws XMLException {
        String relativepath;
        File relativeFile;
        XmlNode root = doc.getRoot();
        XmlNode imageNode = root.getChild(ImageTag);
        String path = imageNode.getAttribute(PathTag);
        this.imageFile = new File(path);
        if (!this.imageFile.isFile() && imageNode.hasAttribute(RelativePathTag) && (relativeFile = RelativePathUtility.getRelativeFile(file, relativepath = imageNode.getAttribute(RelativePathTag))).isFile()) {
            this.imageFile = relativeFile;
        }
    }

    public LightweightDocument(File file) throws IOException, XMLException {
        File relativeFile;
        String line;
        this.docFile = file;
        FileInputStream in = new FileInputStream(file);
        Matcher matcher = null;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        do {
            if ((line = reader.readLine()) == null) continue;
            matcher = PathsPattern.matcher(line);
        } while (line != null && !matcher.matches());
        reader.close();
        if (matcher == null) {
            throw new IOException(Locale.LOCALE.get("EmptyFileError", file.getName()));
        }
        if (!matcher.matches()) {
            throw new XMLException(Locale.LOCALE.get("MissingImageTagError"));
        }
        String path = matcher.replaceFirst("$1");
        if (path.length() == 0) {
            throw new XMLException(Locale.LOCALE.get("MissingImagePathError"));
        }
        this.imageFile = new File(matcher.replaceFirst("$1"));
        String relativePath = matcher.replaceFirst("$3");
        if (relativePath.length() > 0 && (relativeFile = RelativePathUtility.getRelativeFile(this.docFile, relativePath)).isFile()) {
            this.imageFile = relativeFile;
        }
    }

    public File getDocFile() {
        return this.docFile;
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public boolean imageFileExists() {
        return this.imageFile != null && this.imageFile.isFile();
    }
}

