/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor;

import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.editor.Locale;
import java.awt.Color;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

class EllipticLabel
extends Box {
    private static final Color TextColor = LightZoneSkin.Colors.BrowserBackground.darker();
    private static final Color BackgroundColor = LightZoneSkin.Colors.BrowserBackground.brighter();
    private static final Color BorderColor = TextColor;
    private JLabel label = new JLabel();
    private int count;

    EllipticLabel() {
        super(1);
        this.label.setForeground(TextColor);
        this.label.setBackground(BackgroundColor);
        this.label.setOpaque(true);
        this.label.setHorizontalAlignment(0);
        Border emptyBorder = BorderFactory.createEmptyBorder(20, 20, 20, 20);
        Border lineBorder = BorderFactory.createLineBorder(BorderColor);
        CompoundBorder border = BorderFactory.createCompoundBorder(lineBorder, emptyBorder);
        this.label.setBorder(border);
        Font font = this.label.getFont();
        font = font.deriveFont(18.0f);
        this.label.setFont(font);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(8));
        box.add(Box.createHorizontalGlue());
        box.add(this.label);
        box.add(Box.createHorizontalGlue());
        box.add(Box.createHorizontalStrut(8));
        this.add(Box.createVerticalGlue());
        this.add(box);
        this.add(Box.createVerticalGlue());
    }

    void increment() {
        this.label.setText(Locale.LOCALE.get("EllipsisMessage", ++this.count));
        this.repaint();
    }

    int getCount() {
        return this.count;
    }

    void reset() {
        this.count = 0;
        this.label.setText("");
    }
}

