/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor;

import com.lightcrafts.model.Engine;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.Preview;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.editor.PreviewSplit;
import com.lightcrafts.ui.operation.OpControl;
import com.lightcrafts.ui.operation.OpStack;
import com.lightcrafts.ui.operation.OpStackListener;
import com.lightcrafts.ui.operation.SelectableControl;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.BorderLayout;
import java.awt.Point;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.event.UndoableEditListener;

public final class EditorControls
extends JPanel {
    private OpStack stack;
    private PreviewSplit container;

    public EditorControls(Engine engine) {
        Preview[] previews;
        List<Preview> previewList = engine.getPreviews();
        int previewCount = previewList.size();
        if (previewCount > 0) {
            previews = new Preview[previewList.size() - 1];
            Iterator<Preview> it = previewList.iterator();
            it.next();
            int i = 0;
            while (it.hasNext()) {
                previews[i++] = it.next();
            }
        } else {
            previews = new Preview[]{};
        }
        this.stack = new OpStack(engine);
        this.container = new PreviewSplit(this.stack, previews);
        this.setLayout(new BorderLayout());
        this.add(this.container);
        this.setBorder(LightZoneSkin.getPaneBorder());
    }

    public EditorControls() {
        this.container = new PreviewSplit();
        this.setLayout(new BorderLayout());
        this.add(this.container);
    }

    public List<Action> getOperations() {
        return this.stack.getAddActions();
    }

    public List<OpControl> getOpControls() {
        return this.stack.getOpControls();
    }

    public void addOpStackListener(OpStackListener listener) {
        this.stack.addOpStackListener(listener);
    }

    public void removeOpStackListener(OpStackListener listener) {
        this.stack.removeOpStackListener(listener);
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        this.stack.addUndoableEditListener(listener);
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.stack.removeUndoableEditListener(listener);
    }

    public void setShowPreview(boolean show) {
        this.container.setShowPreview(show);
    }

    public void setPreview(Preview preview) {
        this.container.setPreview(preview);
    }

    public void setDropper(Point p) {
        this.container.setDropper(p);
    }

    public void addControl(SelectableControl control) {
        this.stack.addControl(control);
    }

    public void removeControl(SelectableControl control) {
        this.stack.removeControl(control);
    }

    public void save(XmlNode root) {
        this.stack.save(root);
    }

    public void restore(XmlNode root) throws XMLException {
        this.stack.restore(root);
    }

    public List<OpControl> addControls(XmlNode root) throws XMLException {
        return this.stack.addControls(root);
    }

    public OpControl addControl(OperationType type, int index) {
        return this.stack.addGenericControl(type, index);
    }

    public void removeControls(List<OpControl> controls) {
        this.stack.removeControls(controls);
    }

    boolean hasRawAdjustments() {
        return this.stack.hasRawAdjustments();
    }
}

