/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor;

import com.lightcrafts.model.Engine;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.Preview;
import com.lightcrafts.ui.ActivityMeter;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.crop.CropMode;
import com.lightcrafts.ui.editor.CropRotateManager;
import com.lightcrafts.ui.editor.CurveTypeButtons;
import com.lightcrafts.ui.editor.Document;
import com.lightcrafts.ui.editor.EditorControls;
import com.lightcrafts.ui.editor.EditorMode;
import com.lightcrafts.ui.editor.EyeButton;
import com.lightcrafts.ui.editor.FitButton;
import com.lightcrafts.ui.editor.LargerButton;
import com.lightcrafts.ui.editor.Locale;
import com.lightcrafts.ui.editor.ModeButtons;
import com.lightcrafts.ui.editor.ModeManager;
import com.lightcrafts.ui.editor.OneToOneButton;
import com.lightcrafts.ui.editor.ProofButton;
import com.lightcrafts.ui.editor.ProofSelectableControl;
import com.lightcrafts.ui.editor.RegionManager;
import com.lightcrafts.ui.editor.RotateButtons;
import com.lightcrafts.ui.editor.ScaleModel;
import com.lightcrafts.ui.editor.SmallerButton;
import com.lightcrafts.ui.editor.TemporaryEditorCommitState;
import com.lightcrafts.ui.editor.XFormModel;
import com.lightcrafts.ui.layout.ToggleTitleBorder;
import com.lightcrafts.ui.mode.AbstractMode;
import com.lightcrafts.ui.mode.ModeOverlay;
import com.lightcrafts.ui.operation.OpControl;
import com.lightcrafts.ui.region.RegionOverlay;
import com.lightcrafts.ui.scroll.CenteringScrollPane;
import com.lightcrafts.ui.scroll.PannerOverlay;
import com.lightcrafts.ui.scroll.ScrollMode;
import com.lightcrafts.ui.toolkit.BoxedButton;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.event.UndoableEditListener;

public class Editor {
    private Engine engine;
    private RegionManager regions;
    private CropRotateManager crop;
    private ModeOverlay overlay;
    private ModeManager modes;
    private EditorControls opControls;
    private Box toolbar;
    private ActivityMeter imagePane;
    private CenteringScrollPane imageScroll;
    private FitButton fitButton;
    private Action proofAction;
    private ScrollMode transientPanMode;
    private MiniScrollMode permanentPanMode;
    private CropMode cropMode;
    private CropMode rotorMode;
    private RegionOverlay regionMode;
    private boolean wasFitMode;

    static void scrollByUnits(JScrollBar scrollbar, int direction, int units) {
        for (int i = 0; i < units; ++i) {
            int delta = direction > 0 ? scrollbar.getUnitIncrement(direction) : -scrollbar.getUnitIncrement(direction);
            int oldValue = scrollbar.getValue();
            int newValue = oldValue + delta;
            if (delta > 0 && newValue < oldValue) {
                newValue = scrollbar.getMaximum();
            } else if (delta < 0 && newValue > oldValue) {
                newValue = scrollbar.getMinimum();
            }
            if (oldValue == newValue) break;
            scrollbar.setValue(newValue);
        }
    }

    static void scrollByBlock(JScrollBar scrollbar, int direction) {
        int oldValue = scrollbar.getValue();
        int blockIncrement = scrollbar.getBlockIncrement(direction);
        int delta = blockIncrement * (direction > 0 ? 1 : -1);
        int newValue = oldValue + delta;
        if (delta > 0 && newValue < oldValue) {
            newValue = scrollbar.getMaximum();
        } else if (delta < 0 && newValue > oldValue) {
            newValue = scrollbar.getMinimum();
        }
        scrollbar.setValue(newValue);
    }

    public void horizontalMouseWheelMoved(MouseWheelEvent e) {
        if (this.transientPanMode != null) {
            this.transientPanMode.getOverlay().getMouseWheelListeners()[0].mouseWheelMoved(e);
        }
    }

    public EditorMode getMode() {
        if (this.modes != null) {
            return this.modes.getMode();
        }
        return null;
    }

    public void setMode(EditorMode mode) {
        if (this.modes != null) {
            this.modes.setEditorMode(mode);
        }
    }

    Editor(Engine engine, ScaleModel scale, XFormModel xform, RegionManager regions, CropRotateManager crop, Document doc) {
        this.engine = engine;
        this.regions = regions;
        this.crop = crop;
        Component image = engine.getComponent();
        this.overlay = new ModeOverlay(image);
        this.imageScroll = new CenteringScrollPane(this.overlay);
        this.imageScroll.setHorizontalScrollBarPolicy(31);
        this.imageScroll.setVerticalScrollBarPolicy(21);
        this.imageScroll.setBorder(LightZoneSkin.getImageBorder());
        this.imagePane = new ActivityMeter(new PannerOverlay(this.imageScroll));
        engine.addEngineListener(this.imagePane);
        this.regionMode = regions.getMode();
        PanningMouseWheelListener mouseWheelListener = new PanningMouseWheelListener();
        this.transientPanMode = new ScrollMode(this.imageScroll);
        this.transientPanMode.getOverlay().addMouseWheelListener(mouseWheelListener);
        this.permanentPanMode = new MiniScrollMode();
        this.permanentPanMode.getOverlay().addMouseWheelListener(mouseWheelListener);
        this.cropMode = crop.getCropMode();
        this.rotorMode = crop.getRotorMode();
        this.opControls = new EditorControls(engine);
        this.opControls.addOpStackListener(regions);
        this.overlay.addMouseInputListener(new MouseInputAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                this.updateDropper(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.updateDropper(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Editor.this.opControls.setDropper(null);
            }

            private void updateDropper(MouseEvent e) {
                Point p = e.getPoint();
                Point q = new Point();
                AffineTransform xform = Editor.this.modes.getOverlayTransform();
                try {
                    xform.inverseTransform(p, q);
                    Editor.this.opControls.setDropper(q);
                }
                catch (NoninvertibleTransformException f) {
                    System.err.println("DocPanel Preview dropper update: " + f.getMessage());
                }
            }
        });
        CurveTypeButtons regionButtons = regions.getCurveTypeButtons();
        this.modes = new ModeManager(this.regionMode, this.cropMode, this.transientPanMode, this.permanentPanMode, this.rotorMode, this.overlay, image, regionButtons, doc);
        this.opControls.addOpStackListener(this.modes);
        xform.addXFormListener(this.modes);
        Action leftAction = crop.getLeftAction();
        Action rightAction = crop.getRightAction();
        RotateButtons rotors = new RotateButtons(leftAction, rightAction);
        ToggleTitleBorder.setBorder(rotors, Locale.LOCALE.get("RotateBorderTitle"));
        ProofSelectableControl proofOp = new ProofSelectableControl(engine);
        ProofButton pb = new ProofButton(this.opControls, proofOp);
        BoxedButton proofButton = new BoxedButton(Locale.LOCALE.get("SoftProofBorderTitle"), pb);
        this.proofAction = pb.getShowHideAction();
        BoxedButton eyeButton = new BoxedButton(Locale.LOCALE.get("EyeBorderTitle"), new EyeButton(engine));
        OneToOneButton oneToOneButton = new OneToOneButton(scale);
        this.fitButton = new FitButton(this, engine, scale);
        LargerButton largerButton = new LargerButton(scale);
        SmallerButton smallerButton = new SmallerButton(scale);
        this.imageScroll.getViewport().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (Editor.this.fitButton.isSelected()) {
                    Editor.this.fitButton.doZoomToFit();
                }
            }
        });
        Box zoomBox = Box.createHorizontalBox();
        zoomBox.add(oneToOneButton);
        zoomBox.add(this.fitButton);
        zoomBox.add(largerButton);
        zoomBox.add(smallerButton);
        ToggleTitleBorder.setBorder(zoomBox, Locale.LOCALE.get("ZoomBorderTitle"));
        ModeButtons modeBox = new ModeButtons(this.modes);
        this.modes.setModeButtons(modeBox);
        this.toolbar = Box.createHorizontalBox();
        this.toolbar.add(Box.createHorizontalStrut(8));
        this.toolbar.add(eyeButton.box);
        this.toolbar.add(Box.createHorizontalStrut(8));
        this.toolbar.add(proofButton.box);
        this.toolbar.add(Box.createHorizontalStrut(8));
        this.toolbar.add(rotors);
        this.toolbar.add(Box.createHorizontalStrut(8));
        this.toolbar.add(zoomBox);
        this.toolbar.add(Box.createHorizontalStrut(8));
        this.toolbar.add(new Separator());
        this.toolbar.add(Box.createHorizontalStrut(8));
        this.toolbar.add(modeBox);
        this.toolbar.add(Box.createHorizontalStrut(8));
        Border border = BorderFactory.createEmptyBorder(3, 0, 3, 0);
        this.toolbar.setBorder(border);
    }

    Editor() {
        JLabel image = new JLabel();
        this.overlay = new ModeOverlay(image);
        this.imageScroll = new CenteringScrollPane(this.overlay);
        this.imageScroll.setHorizontalScrollBarPolicy(31);
        this.imageScroll.setVerticalScrollBarPolicy(21);
        this.imagePane = new ActivityMeter(new PannerOverlay(this.imageScroll));
        this.opControls = new EditorControls();
        this.regions = new RegionManager();
        AbstractAction showHideAction = this.regions.getShowHideAction();
        showHideAction.actionPerformed(null);
        showHideAction.setEnabled(false);
        RotateButtons rotors = new RotateButtons();
        ToggleTitleBorder.setBorder(rotors, Locale.LOCALE.get("RotateBorderTitle"));
        ProofButton proofButton = new ProofButton();
        EyeButton eyeButton = new EyeButton();
        ToggleTitleBorder.setBorder(proofButton, Locale.LOCALE.get("SoftProofBorderTitle"));
        ToggleTitleBorder.setBorder(eyeButton, Locale.LOCALE.get("EyeBorderTitle"));
        OneToOneButton oneToOneButton = new OneToOneButton();
        FitButton fitButton = new FitButton();
        LargerButton largerButton = new LargerButton();
        SmallerButton smallerButton = new SmallerButton();
        Box zoomBox = Box.createHorizontalBox();
        zoomBox.add(oneToOneButton);
        zoomBox.add(fitButton);
        zoomBox.add(largerButton);
        zoomBox.add(smallerButton);
        ToggleTitleBorder.setBorder(zoomBox, Locale.LOCALE.get("ZoomBorderTitle"));
        ModeButtons modeBox = new ModeButtons();
        ToggleTitleBorder.setBorder(modeBox, Locale.LOCALE.get("ModeBorderTitle"));
        this.toolbar = Box.createHorizontalBox();
        this.toolbar.add(Box.createHorizontalGlue());
        this.toolbar.add(Box.createHorizontalStrut(8));
        this.toolbar.add(zoomBox);
        this.toolbar.add(Box.createHorizontalStrut(8));
        this.toolbar.add(proofButton);
        this.toolbar.add(Box.createHorizontalStrut(8));
        this.toolbar.add(eyeButton);
        this.toolbar.add(Box.createHorizontalStrut(8));
        this.toolbar.add(rotors);
        this.toolbar.add(new Separator());
        this.toolbar.add(Box.createHorizontalStrut(8));
        this.toolbar.add(modeBox);
        this.toolbar.add(Box.createHorizontalStrut(8));
        this.toolbar.add(new Separator());
        this.toolbar.add(Box.createHorizontalStrut(8));
        this.toolbar.add(Box.createHorizontalGlue());
        Border border = BorderFactory.createEmptyBorder(3, 0, 3, 0);
        this.toolbar.setBorder(border);
    }

    public void pushFitMode() {
        this.wasFitMode = this.fitButton.isSelected();
        this.fitButton.setSelected(false);
    }

    public boolean popFitMode() {
        this.fitButton.setSelected(this.wasFitMode);
        return this.wasFitMode;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public ModeManager getModeManager() {
        return this.modes;
    }

    public EditorControls getToolStack() {
        return this.opControls;
    }

    public JComponent getToolBar() {
        return this.toolbar;
    }

    public JComponent getImage() {
        return this.imagePane;
    }

    public void setPreview(Preview preview) {
        this.opControls.setPreview(preview);
    }

    public void showWait(String text) {
        this.imagePane.showWait(text);
    }

    public void hideWait() {
        this.imagePane.hideWait();
    }

    public void setDisabledText(String text) {
    }

    public List<OpControl> addControls(XmlNode node) throws XMLException {
        List<OpControl> controls = this.opControls.addControls(node);
        for (OpControl control : controls) {
            this.regions.opChanged(control);
        }
        this.regions.addSaved(controls, node);
        return controls;
    }

    public OpControl addControl(OperationType type, int index) {
        return this.opControls.addControl(type, 0);
    }

    public void removeControls(List<OpControl> controls) {
        this.opControls.removeControls(controls);
    }

    void addUndoableEditListener(UndoableEditListener listener) {
        this.crop.addUndoableEditListener(listener);
        this.opControls.addUndoableEditListener(listener);
        this.regions.addUndoableEditListener(listener);
    }

    void removeUndoableEditListener(UndoableEditListener listener) {
        this.crop.removeUndoableEditListener(listener);
        this.opControls.removeUndoableEditListener(listener);
        this.regions.removeUndoableEditListener(listener);
    }

    Rectangle getMaxImageBounds() {
        JViewport viewport = this.imageScroll.getViewport();
        Rectangle bounds = viewport.getVisibleRect();
        bounds = ModeOverlay.insetPercent(bounds);
        return bounds;
    }

    List<Action> getOperations() {
        return this.opControls.getOperations();
    }

    Action getProofAction() {
        return this.proofAction;
    }

    boolean hasRawAdjustments() {
        return this.opControls.hasRawAdjustments();
    }

    void dispose() {
        if (this.modes != null) {
            this.modes.dispose();
        }
        ToggleTitleBorder.unsetAllBorders(this.toolbar);
        if (this.transientPanMode != null) {
            this.transientPanMode.dispose();
        }
        if (this.permanentPanMode != null) {
            this.permanentPanMode.dispose();
        }
        if (this.cropMode != null) {
            this.cropMode.dispose();
        }
        if (this.rotorMode != null) {
            this.rotorMode.dispose();
        }
        if (this.regionMode != null) {
            this.regionMode.dispose();
        }
    }

    public TemporaryEditorCommitState saveStart() {
        boolean isRotateActive;
        boolean isCropActive = this.overlay.peekMode() == this.cropMode;
        boolean bl = isRotateActive = this.overlay.peekMode() == this.rotorMode;
        if (isCropActive || isRotateActive) {
            this.modes.setNoMode();
        }
        TemporaryEditorCommitState state = new TemporaryEditorCommitState(isCropActive, isRotateActive);
        return state;
    }

    public void saveEnd(TemporaryEditorCommitState state) {
        if (state.isCropActive) {
            this.modes.setCropMode();
        } else if (state.isRotateActive) {
            this.modes.setRotateMode();
        }
    }

    void save(XmlNode node) {
        this.opControls.save(node);
        List<OpControl> opControls = this.opControls.getOpControls();
        this.regions.save(opControls, node);
        this.crop.save(node);
    }

    void restore(XmlNode node) throws XMLException {
        try {
            this.opControls.restore(node);
        }
        catch (XMLException e) {
            this.dispose();
            throw e;
        }
        List<OpControl> opControls = this.opControls.getOpControls();
        for (OpControl control : opControls) {
            this.regions.opChanged(control);
        }
        this.regions.restore(opControls, node);
        this.crop.restore(node);
    }

    static class Separator
    extends JSeparator {
        Separator() {
            super(1);
            this.setMaximumSize(new Dimension(3, 32));
        }
    }

    class PanningMouseWheelListener
    implements MouseWheelListener {
        PanningMouseWheelListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (Editor.this.imageScroll.isWheelScrollingEnabled() && e.getScrollAmount() != 0) {
                int direction;
                JScrollBar toScroll = e.getScrollType() < 2 ? Editor.this.imageScroll.getVerticalScrollBar() : Editor.this.imageScroll.getHorizontalScrollBar();
                int n = direction = e.getWheelRotation() < 0 ? -1 : 1;
                if (e.getScrollType() == 0) {
                    Editor.scrollByUnits(toScroll, direction, e.getScrollAmount());
                } else if (e.getScrollType() == 1) {
                    Editor.scrollByBlock(toScroll, direction);
                } else {
                    direction = e.getWheelRotation() < 0 ? 1 : -1;
                    Editor.scrollByUnits(toScroll, direction, Math.abs(e.getWheelRotation()));
                }
            }
        }
    }

    private static class MiniScrollMode
    extends AbstractMode {
        private JPanel overlay = new JPanel();

        @Override
        public JComponent getOverlay() {
            return this.overlay;
        }

        @Override
        public void addMouseInputListener(MouseInputListener listener) {
            this.overlay.addMouseListener(listener);
            this.overlay.addMouseMotionListener(listener);
        }

        @Override
        public void removeMouseInputListener(MouseInputListener listener) {
            this.overlay.removeMouseListener(listener);
            this.overlay.removeMouseMotionListener(listener);
        }
    }
}

