/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor;

import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.editor.Locale;
import com.lightcrafts.ui.editor.RegionManager;
import com.lightcrafts.ui.toolkit.CoolButton;
import com.lightcrafts.ui.toolkit.CoolToggleButton;
import com.lightcrafts.ui.toolkit.IconFactory;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import org.jvnet.substance.color.ColorScheme;

public class CurveTypeButtons
extends Box {
    public static final Icon PolygonIcon = IconFactory.createInvertedIcon(CurveTypeButtons.class, "polygon.png");
    public static final Icon BasisIcon = IconFactory.createInvertedIcon(CurveTypeButtons.class, "basis.png");
    public static final Icon BezierIcon = IconFactory.createInvertedIcon(CurveTypeButtons.class, "bezier.png");
    public static final Icon RegionGenericIcon = IconFactory.createInvertedIcon(CurveTypeButtons.class, "regiongeneric.png");
    private static String PolygonToolTip = Locale.LOCALE.get("PolygonToolTip");
    private static String BezierToolTip = Locale.LOCALE.get("BezierToolTip");
    private static String BasisToolTip = Locale.LOCALE.get("BasisToolTip");
    private RegionManager regions;
    private CoolToggleButton polygon;
    private CoolToggleButton bezier;
    private CoolToggleButton basis;
    private boolean isUpdating;
    ColorScheme orangeScheme = new LightZoneSkin.CustomColorScheme(LightZoneSkin.Colors.LZOrange);

    CurveTypeButtons(RegionManager regions) {
        super(0);
        this.regions = regions;
        this.initButtons();
        this.updateFromFactory();
        ButtonGroup group = new ButtonGroup();
        this.polygon.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    RegionManager regions = CurveTypeButtons.this.regions;
                    CurveTypeButtons.this.isUpdating = true;
                    regions.setCurveType(0);
                    CurveTypeButtons.this.isUpdating = false;
                }
            }
        });
        group.add(this.polygon);
        this.add(this.polygon);
        this.basis.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    RegionManager regions = CurveTypeButtons.this.regions;
                    CurveTypeButtons.this.isUpdating = true;
                    regions.setCurveType(4);
                    CurveTypeButtons.this.isUpdating = false;
                }
            }
        });
        group.add(this.basis);
        this.add(this.basis);
        this.bezier.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    RegionManager regions = CurveTypeButtons.this.regions;
                    CurveTypeButtons.this.isUpdating = true;
                    regions.setCurveType(2);
                    CurveTypeButtons.this.isUpdating = false;
                }
            }
        });
        group.add(this.bezier);
        this.add(this.bezier);
    }

    CurveTypeButtons() {
        super(0);
        this.initButtons();
        this.polygon.setEnabled(false);
        this.add(this.polygon);
        this.basis.setEnabled(false);
        this.add(this.basis);
        this.bezier.setEnabled(false);
        this.add(this.bezier);
    }

    void updateFromFactory() {
        if (!this.isUpdating) {
            switch (this.regions.getCurveType()) {
                case 0: {
                    this.polygon.setSelected(true);
                    break;
                }
                case 2: {
                    this.bezier.setSelected(true);
                    break;
                }
                case 4: {
                    this.basis.setSelected(true);
                }
            }
        }
    }

    private void initButtons() {
        this.polygon = new CoolToggleButton(CoolButton.ButtonStyle.LEFT);
        this.polygon.setIcon(PolygonIcon);
        this.basis = new CoolToggleButton(CoolButton.ButtonStyle.CENTER);
        this.basis.setIcon(BasisIcon);
        this.bezier = new CoolToggleButton(CoolButton.ButtonStyle.RIGHT);
        this.bezier.setIcon(BezierIcon);
        this.polygon.putClientProperty("substancelaf.theme", LightZoneSkin.orangeTheme);
        this.basis.putClientProperty("substancelaf.theme", LightZoneSkin.orangeTheme);
        this.bezier.putClientProperty("substancelaf.theme", LightZoneSkin.orangeTheme);
        this.polygon.setToolTipText(PolygonToolTip);
        this.basis.setToolTipText(BasisToolTip);
        this.bezier.setToolTipText(BezierToolTip);
    }
}

