/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.datatips.xswing;

import com.lightcrafts.ui.datatips.xswing.DataTipCell;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

class ListDataTipCell
implements DataTipCell {
    private final JList list;
    private final int rowIndex;

    ListDataTipCell(JList list, int rowIndex) {
        this.list = list;
        this.rowIndex = rowIndex;
    }

    @Override
    public boolean isSet() {
        return this.rowIndex >= 0;
    }

    @Override
    public Rectangle getCellBounds() {
        Rectangle cellRect = this.list.getCellBounds(this.rowIndex, this.rowIndex);
        return cellRect;
    }

    @Override
    public Component getRendererComponent() {
        Object item = this.list.getModel().getElementAt(this.rowIndex);
        boolean isSelected = this.list.isSelectedIndex(this.rowIndex);
        boolean isFocussed = this.list.hasFocus() && this.rowIndex == this.list.getLeadSelectionIndex();
        ListCellRenderer renderer = this.list.getCellRenderer();
        Component component = renderer.getListCellRendererComponent(this.list, item, this.rowIndex, isSelected, isFocussed);
        return component;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListDataTipCell listDataTipCell = (ListDataTipCell)o;
        return this.rowIndex == listDataTipCell.rowIndex;
    }

    public int hashCode() {
        return this.rowIndex;
    }
}

