/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.crop;

import com.lightcrafts.model.CropBounds;
import com.lightcrafts.ui.crop.CropControl;
import com.lightcrafts.ui.crop.CropListener;
import com.lightcrafts.ui.crop.CropOverlay;
import com.lightcrafts.ui.crop.CropPopupMenu;
import com.lightcrafts.ui.crop.ResetAction;
import com.lightcrafts.ui.mode.AbstractMode;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.MouseInputListener;

public class CropMode
extends AbstractMode {
    private CropOverlay overlay;
    private AffineTransform xform;
    private CropControl control;
    private LinkedList<CropListener> listeners = new LinkedList();

    public CropMode(boolean isRotateOnly) {
        ResetAction reset = new ResetAction();
        this.control = new CropControl(reset, isRotateOnly);
        this.overlay = new CropOverlay(isRotateOnly);
        this.control.setOverlay(this.overlay);
        this.xform = new AffineTransform();
        this.overlay.addMouseListener(new CropPopupMenu(this, reset));
        this.overlay.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CropMode.this.doCrop();
            }
        }, KeyStroke.getKeyStroke(10, 0), 2);
        this.overlay.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CropBounds resetBounds = CropMode.this.getResetCropBounds();
                CropMode.this.setCropWithConstraints(resetBounds);
                CropMode.this.doCrop();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    @Override
    public void enter() {
        super.enter();
        this.overlay.modeEntered();
        this.control.unlock();
    }

    public void setResetCropBounds(CropBounds crop) {
        if (crop != null) {
            crop = CropBounds.transform(this.xform, crop);
        }
        this.control.setResetValue(crop);
    }

    public CropBounds getResetCropBounds() {
        CropBounds crop = this.control.getResetValue();
        if (crop != null) {
            try {
                AffineTransform inverse = this.xform.createInverse();
                crop = CropBounds.transform(inverse, crop);
            }
            catch (NoninvertibleTransformException e) {
                crop = null;
            }
        }
        return crop;
    }

    Dimension2D getRotateLimitDimensions() {
        Dimension2D limit = this.overlay.getRotateLimitDimensions();
        if (limit != null) {
            double scale = this.xform.getScaleX();
            limit.setSize(limit.getWidth() / scale, limit.getHeight() / scale);
        }
        return limit;
    }

    void setRotateLimitDimensions(Dimension2D limit) {
        if (limit != null) {
            double scale = this.xform.getScaleX();
            limit.setSize(limit.getWidth() * scale, limit.getHeight() * scale);
            this.overlay.setRotateLimitDimensions(limit);
        }
    }

    public void addCropListener(CropListener listener) {
        this.listeners.add(listener);
    }

    public void removeCropListener(CropListener listener) {
        this.listeners.add(listener);
    }

    public CropControl getControl() {
        return this.control;
    }

    public CropBounds getCrop() {
        CropBounds rect = this.overlay.getCrop();
        if (rect != null) {
            try {
                AffineTransform inverse = this.xform.createInverse();
                return CropBounds.transform(inverse, rect);
            }
            catch (NoninvertibleTransformException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public void setCrop(CropBounds crop) {
        if (crop != null) {
            crop = CropBounds.transform(this.xform, crop);
        }
        this.overlay.setCrop(crop);
    }

    public void setCropWithConstraints(CropBounds crop) {
        if (crop != null) {
            crop = CropBounds.transform(this.xform, crop);
        }
        this.overlay.setCropWithConstraints(crop);
    }

    public void resetCrop() {
        for (CropListener listener : this.listeners) {
            listener.unCrop();
        }
    }

    public void doCrop() {
        if (this.isIn()) {
            CropBounds crop = this.getCrop();
            for (CropListener listener : this.listeners) {
                listener.cropCommitted(crop);
            }
        }
    }

    @Override
    public JComponent getOverlay() {
        return this.overlay;
    }

    @Override
    public void addMouseInputListener(MouseInputListener listener) {
        this.overlay.addMouseListener(listener);
        this.overlay.addMouseMotionListener(listener);
    }

    @Override
    public void removeMouseInputListener(MouseInputListener listener) {
        this.overlay.removeMouseListener(listener);
        this.overlay.removeMouseMotionListener(listener);
    }

    @Override
    public void setTransform(AffineTransform xform) {
        CropBounds crop = this.getCrop();
        CropBounds reset = this.getResetCropBounds();
        Dimension2D rotateLimitDimensions = this.getRotateLimitDimensions();
        this.xform = xform;
        this.setCrop(crop);
        this.setResetCropBounds(reset);
        this.setRotateLimitDimensions(rotateLimitDimensions);
    }

    @Override
    public void setUnderlayBounds(Rectangle bounds) {
        this.overlay.setUnderlayRect(bounds);
    }

    @Override
    public boolean wantsAutocroll() {
        return true;
    }

    @Override
    public void dispose() {
        this.overlay.dispose();
    }
}

