/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.view;

import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.browser.model.ImageDatum;
import com.lightcrafts.ui.browser.view.AbstractImageBrowser;
import com.lightcrafts.ui.browser.view.ImageDatumRenderer;
import com.lightcrafts.ui.browser.view.RatingActions;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

class StarSlider {
    private static int StarSize = 12;
    private static final GeneralPath StarShape = new GeneralPath();
    private static final Shape DotShape;
    private double stars;
    private boolean highlight;
    private ImageDatum datum;
    private Rectangle rect;
    private AbstractImageBrowser browser;

    StarSlider(AbstractImageBrowser browser) {
        this.browser = browser;
    }

    void setup(ImageDatum datum, Rectangle rect) {
        this.datum = datum;
        this.rect = ImageDatumRenderer.getTextRectangle(rect);
        ImageMetadata meta = datum.getMetadata(true);
        int rating = meta.getRating();
        this.stars = rating > 0 ? (double)rating : 0.0;
    }

    void paint(Graphics2D g) {
        Color oldColor = g.getColor();
        Object oldHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Shape oldClip = g.getClip();
        g.setColor(LightZoneSkin.Colors.BrowserLabelBackground);
        g.fill(this.rect);
        if (this.highlight) {
            g.setColor(LightZoneSkin.Colors.BrowserLabelForeground.brighter());
        } else {
            g.setColor(LightZoneSkin.Colors.BrowserLabelForeground);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (int n = 1; n <= 5; ++n) {
            Point2D loc = this.starToPoint((double)n - 0.5);
            AffineTransform xform = AffineTransform.getTranslateInstance(loc.getX(), loc.getY());
            Shape dot = xform.createTransformedShape(DotShape);
            g.fill(dot);
        }
        Point2D left = this.starToPoint(0.0);
        Point2D right = this.starToPoint(this.stars);
        Rectangle2D.Double clip = new Rectangle2D.Double(left.getX(), this.rect.y, right.getX() - left.getX(), this.rect.height);
        g.setClip(clip);
        for (int n = 1; n <= 5; ++n) {
            Point2D loc = this.starToPoint((double)n - 0.5);
            AffineTransform xform = AffineTransform.getTranslateInstance(loc.getX(), loc.getY());
            Shape star = xform.createTransformedShape(StarShape);
            g.fill(star);
        }
        g.setClip(oldClip);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
        g.setColor(oldColor);
    }

    boolean isStarsEvent(MouseEvent event) {
        if (event.getID() == 501 || event.getID() == 506 || event.getID() == 502) {
            Point p = event.getPoint();
            if (this.rect != null && this.rect.contains(p)) {
                return true;
            }
        }
        return false;
    }

    void handleEvent(MouseEvent event) {
        if (event.getID() == 501) {
            this.stars = this.pointToStar(event.getPoint());
        }
        if (event.getID() == 506) {
            this.stars = this.pointToStar(event.getPoint());
        }
        if (event.getID() == 502) {
            int rating = (int)Math.round(this.stars);
            if (rating <= 0) {
                this.stars = 0.0;
                RatingActions.clearRating(this.datum, this.browser);
            } else {
                rating = Math.min(rating, 5);
                this.stars = rating;
                RatingActions.setRating(this.datum, rating, this.browser);
            }
        }
    }

    boolean updateHighlighted(Point p) {
        boolean wasHighlight = this.highlight;
        this.highlight = this.rect.contains(p);
        return this.highlight && !wasHighlight || !this.highlight && wasHighlight;
    }

    Rectangle getStarsRect() {
        return (Rectangle)this.rect.clone();
    }

    private double pointToStar(Point p) {
        double mid = this.rect.getX() + this.rect.getWidth() / 2.0;
        double star = ((double)p.x - mid) / (1.1 * (double)StarSize) + 2.5;
        return star;
    }

    private Point2D starToPoint(double star) {
        double mid = this.rect.getX() + this.rect.getWidth() / 2.0;
        double x = mid + (star - 2.5) * (1.1 * (double)StarSize);
        double y = this.rect.getY() + this.rect.getHeight() / 2.0;
        return new Point2D.Double(x, y);
    }

    static {
        double bigRadius = 0.5 * (double)StarSize;
        double smallRadius = 0.2 * (double)StarSize;
        double angle = -1.5707963267948966;
        double x = bigRadius * Math.cos(angle);
        double y = bigRadius * Math.sin(angle);
        StarShape.moveTo((float)x, (float)y);
        for (int n = 1; n <= 5; ++n) {
            x = smallRadius * Math.cos(angle += 0.6283185307179586);
            y = smallRadius * Math.sin(angle);
            StarShape.lineTo((float)x, (float)y);
            x = bigRadius * Math.cos(angle += 0.6283185307179586);
            y = bigRadius * Math.sin(angle);
            StarShape.lineTo((float)x, (float)y);
        }
        StarShape.closePath();
        DotShape = new Arc2D.Double(0.0, 0.0, 2.0, 2.0, 0.0, 360.0, 1);
    }
}

