/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.view;

import com.lightcrafts.ui.browser.model.ImageDatum;
import com.lightcrafts.ui.browser.view.AbstractImageBrowser;
import com.lightcrafts.ui.browser.view.ImageBrowserSelectionModel;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

class SingleImageBrowserSelectionModel
extends ImageBrowserSelectionModel {
    private ImageDatum selected;
    private AbstractImageBrowser browser;

    SingleImageBrowserSelectionModel(AbstractImageBrowser browser) {
        super(browser);
        this.browser = browser;
    }

    @Override
    void setLeadSelected(ImageDatum datum) {
        if (this.selected != datum) {
            this.selected = datum;
            this.browser.notifySelectionChanged();
            this.browser.repaint();
        }
    }

    @Override
    void addSelected(ImageDatum datum) {
        if (this.selected == null) {
            this.setLeadSelected(datum);
        }
    }

    @Override
    void addSelected(Collection<ImageDatum> datums) {
        if (datums.size() == 1) {
            this.setLeadSelected(datums.iterator().next());
        }
    }

    @Override
    void setSelected(List<ImageDatum> datums) {
        if (datums.size() == 1) {
            this.setLeadSelected(datums.get(0));
        }
    }

    @Override
    void removeSelected(ImageDatum datum) {
        if (this.selected == datum) {
            this.setLeadSelected(null);
        }
    }

    @Override
    void clearSelected() {
        if (this.selected != null) {
            this.browser.repaint(this.selected);
            this.selected = null;
            this.browser.notifySelectionChanged();
        }
    }

    @Override
    ImageDatum getLeadSelected() {
        return this.selected;
    }

    @Override
    List<ImageDatum> getSelected() {
        if (this.selected != null) {
            return Collections.singletonList(this.selected);
        }
        return Collections.emptyList();
    }

    @Override
    boolean isSelected(ImageDatum datum) {
        return this.selected == datum;
    }

    @Override
    boolean isLeadSelected(ImageDatum datum) {
        return this.selected == datum;
    }
}

