/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.view;

import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.browser.model.ImageDatum;
import com.lightcrafts.ui.browser.model.ImageGroup;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

class ImageGroupCountRenderer {
    static int HInset = 4;
    static int VInset = 12;
    static int ArcRadius = 8;
    static Color TextColor = LightZoneSkin.Colors.BrowserLabelForeground;
    static Color BackColor = LightZoneSkin.Colors.BrowserImageTypeLabelBackground;
    static Color BorderColor = Color.lightGray;

    ImageGroupCountRenderer() {
    }

    static void paint(Graphics2D g, Rectangle2D rect, ImageDatum datum) {
        ImageGroup group = datum.getGroup();
        int count = group.getImageDatums().size();
        String text = Integer.toString(count);
        ImageGroupCountRenderer.paint(g, rect, text);
    }

    static void paint(Graphics2D g, Rectangle2D rect, String text) {
        Point2D textOrigin = ImageGroupCountRenderer.getTextOrigin(rect, g, text);
        FontMetrics metrics = g.getFontMetrics();
        Rectangle2D textBounds = metrics.getStringBounds(text, g);
        double x = textOrigin.getX();
        double y = textOrigin.getY();
        textBounds = new Rectangle2D.Double(x + textBounds.getX(), y + textBounds.getY(), textBounds.getWidth(), textBounds.getHeight());
        RoundRectangle2D.Double background = new RoundRectangle2D.Double(textBounds.getX() - (double)(ArcRadius / 2), textBounds.getY() - (double)(ArcRadius / 2), textBounds.getWidth() + (double)ArcRadius, textBounds.getHeight() + (double)ArcRadius, ArcRadius, ArcRadius);
        Color oldColor = g.getColor();
        AffineTransform xform = AffineTransform.getTranslateInstance(-2.0, -2.0);
        Area stack = new Area(xform.createTransformedShape(background));
        stack.subtract(new Area(background));
        g.setColor(BackColor);
        g.fill(stack);
        g.setColor(BorderColor);
        g.draw(stack);
        g.setColor(BackColor);
        g.fill(background);
        g.setColor(BorderColor);
        g.draw(background);
        g.setColor(TextColor);
        g.drawString(text, (float)x, (float)y);
        g.setColor(oldColor);
    }

    private static Point2D getTextOrigin(Rectangle2D rect, Graphics2D g, String text) {
        Point2D ul = ImageGroupCountRenderer.getUpperLeft(rect);
        FontMetrics metrics = g.getFontMetrics();
        Rectangle2D bounds = metrics.getStringBounds(text, g);
        double x = ul.getX() + bounds.getX();
        double y = ul.getY() + bounds.getY() + bounds.getHeight();
        return new Point2D.Double(x, y);
    }

    private static Point2D getUpperLeft(Rectangle2D rect) {
        double x = rect.getX() + (double)HInset + (double)ArcRadius;
        double y = rect.getY() + (double)VInset + (double)ArcRadius;
        return new Point2D.Double(x, y);
    }
}

