/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.view;

import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.browser.model.ImageDatum;
import com.lightcrafts.ui.browser.model.ImageDatumType;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

class ImageDatumTypeRenderer {
    static int HInset = 4;
    static int VInset = 28;
    static int ArcRadius = 8;
    static Color TextColor = LightZoneSkin.Colors.BrowserLabelForeground;
    static Color BackColor = LightZoneSkin.Colors.BrowserImageTypeLabelBackground;

    ImageDatumTypeRenderer() {
    }

    static void paint(Graphics2D g, Rectangle2D rect, ImageDatum datum) {
        ImageDatumType type = datum.getType();
        String text = type.toString();
        ImageDatumTypeRenderer.paint(g, rect, text);
    }

    static void paint(Graphics2D g, Rectangle2D rect, String text) {
        Point2D textOrigin = ImageDatumTypeRenderer.getTextOrigin(rect, g, text);
        FontMetrics metrics = g.getFontMetrics();
        Rectangle2D textBounds = metrics.getStringBounds(text, g);
        double x = textOrigin.getX();
        double y = textOrigin.getY();
        textBounds = new Rectangle2D.Double(x + textBounds.getX(), y + textBounds.getY(), textBounds.getWidth(), textBounds.getHeight());
        RoundRectangle2D.Double background = new RoundRectangle2D.Double(textBounds.getX() - (double)(ArcRadius / 2), textBounds.getY() - (double)(ArcRadius / 2), textBounds.getWidth() + (double)ArcRadius, textBounds.getHeight() + (double)ArcRadius, ArcRadius, ArcRadius);
        Color oldColor = g.getColor();
        g.setColor(BackColor);
        g.fill(background);
        g.setColor(TextColor);
        g.drawString(text, (float)x, (float)y);
        g.setColor(oldColor);
    }

    private static Point2D getTextOrigin(Rectangle2D rect, Graphics2D g, String text) {
        Point2D lr = ImageDatumTypeRenderer.getLowerRight(rect);
        FontMetrics metrics = g.getFontMetrics();
        Rectangle2D bounds = metrics.getStringBounds(text, g);
        double x = lr.getX() - bounds.getWidth() - bounds.getX();
        double y = lr.getY() - bounds.getHeight() - bounds.getY();
        return new Point2D.Double(x, y);
    }

    private static Point2D getLowerRight(Rectangle2D rect) {
        double x = rect.getX() + rect.getWidth() - (double)HInset - (double)ArcRadius;
        double y = rect.getY() + rect.getHeight() - (double)VInset - (double)ArcRadius;
        return new Point2D.Double(x, y);
    }
}

