/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.view;

import com.lightcrafts.ui.browser.model.ImageDatum;
import com.lightcrafts.ui.browser.model.PreviewUpdater;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ImageBrowserEvent {
    private ImageDatum lead;
    private List<ImageDatum> datums;
    private PreviewUpdater preview;
    private ArrayList<PreviewUpdater> previews;
    private int imageCount;

    ImageBrowserEvent(ImageDatum datum, List<ImageDatum> datums, PreviewUpdater preview, List<PreviewUpdater> previews, int imageCount) {
        this.lead = datum;
        this.datums = new ArrayList<ImageDatum>(datums);
        this.preview = preview;
        this.previews = new ArrayList<PreviewUpdater>(previews);
        this.imageCount = imageCount;
    }

    public File getFile() {
        return this.lead != null ? this.lead.getFile() : null;
    }

    public List<File> getFiles() {
        ArrayList<File> files = new ArrayList<File>();
        for (ImageDatum datum : this.datums) {
            files.add(datum.getFile());
        }
        return files;
    }

    public PreviewUpdater getPreview() {
        return this.preview;
    }

    public List<PreviewUpdater> getSelectedPreviews() {
        return new ArrayList<PreviewUpdater>(this.previews);
    }

    public int getImageCount() {
        return this.imageCount;
    }

    ImageDatum getLead() {
        return this.lead;
    }

    List<ImageDatum> getDatums() {
        return this.datums;
    }
}

