/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.view;

import com.lightcrafts.ui.browser.model.ImageList;
import com.lightcrafts.ui.browser.view.AbstractImageBrowser;
import com.lightcrafts.ui.browser.view.CollapsedImageBrowser;
import com.lightcrafts.ui.browser.view.ExpandedImageBrowser;
import java.util.prefs.Preferences;

public class BrowserFactory {
    private static final boolean IsDefaultBrowserCollapsed = false;
    private static final Preferences Prefs = Preferences.userRoot().node("/com/lightcrafts/ui/browser/view");
    private static final String CollapsedKey = "BrowserCollapsed";

    public static AbstractImageBrowser createExpanded(ImageList images) {
        Prefs.putBoolean(CollapsedKey, false);
        return new ExpandedImageBrowser(images);
    }

    public static AbstractImageBrowser createCollapsed(ImageList images) {
        Prefs.putBoolean(CollapsedKey, true);
        return new CollapsedImageBrowser(images);
    }

    public static AbstractImageBrowser createRecent(ImageList images) {
        return BrowserFactory.isDefaultCollapsed() ? BrowserFactory.createCollapsed(images) : BrowserFactory.createExpanded(images);
    }

    public static boolean isDefaultCollapsed() {
        return Prefs.getBoolean(CollapsedKey, false);
    }

    public static boolean isCollapsed(AbstractImageBrowser browser) {
        return browser instanceof CollapsedImageBrowser;
    }

    public static void dispose(AbstractImageBrowser browser) {
        browser.dispose();
    }
}

