/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.model;

import com.lightcrafts.image.libs.LCImageLibException;
import com.lightcrafts.image.libs.LCJPEGReader;
import com.lightcrafts.image.libs.LCJPEGWriter;
import com.lightcrafts.image.libs.OutputStreamImageDataReceiver;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.types.ImageType;
import com.lightcrafts.image.types.LZNImageType;
import com.lightcrafts.image.types.RawImageType;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.ui.browser.model.FastImageFactory;
import com.lightcrafts.ui.browser.model.ImageProviderReceiver;
import com.lightcrafts.ui.browser.model.Thumbnailer;
import com.lightcrafts.utils.filecache.FileCache;
import com.lightcrafts.utils.filecache.FileCacheFactory;
import java.awt.EventQueue;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class PreviewUpdater
extends Thread {
    private static final Object Monitor = new Object();
    public static final int PreviewSize = 1536;
    private static int DebugPreviewCount;
    private static boolean Debug;
    private FileCache cache;
    private RenderedImage image;
    private ImageMetadata meta;
    private Set<Observer> observers;
    private Provider provider;
    private boolean stillInterested;
    private boolean done;
    private PreviewUpdater prevUpdater;

    public static void cachePreviewForImage(File file, RenderedImage image) {
        FileCache cache = FileCacheFactory.get(file);
        if (cache == null) {
            return;
        }
        String key = PreviewUpdater.getImageKey(file);
        try {
            FileOutputStream out = cache.putToStream(key);
            OutputStreamImageDataReceiver receiver = new OutputStreamImageDataReceiver(out);
            try {
                LCJPEGWriter writer = new LCJPEGWriter(receiver, 32768, image.getWidth(), image.getHeight(), image.getColorModel().getNumComponents(), 2, 90);
                writer.putImage(image);
                writer.dispose();
            }
            catch (LCImageLibException e) {
                PreviewUpdater.logNonFatalStatic(file, e, "caching preview");
                cache.remove(key);
            }
            ((OutputStream)out).close();
            receiver.dispose();
        }
        catch (IOException e) {
            PreviewUpdater.logNonFatalStatic(file, e, "caching preview");
            PreviewUpdater.removeCacheSilentStatic(cache, file);
        }
    }

    public static void clearCachedPreviewForImage(ImageMetadata meta, FileCache cache) {
        PreviewUpdater updater = new PreviewUpdater(cache, null, meta);
        updater.removeCacheSilent();
        updater.dispose();
    }

    public static long getCachedPreviewTime(ImageMetadata meta, FileCache cache) {
        File file = meta.getFile();
        String key = PreviewUpdater.getImageKey(file);
        File cacheFile = cache.getFileFor(key);
        if (cacheFile != null) {
            return cacheFile.lastModified();
        }
        return -1L;
    }

    PreviewUpdater(FileCache cache, RenderedImage image, ImageMetadata meta, Provider provider) {
        this(cache, image, meta);
        this.provider = provider;
    }

    PreviewUpdater(PreviewUpdater oldUpdater, RenderedImage image, ImageMetadata meta) {
        this(oldUpdater.cache, image, meta);
        this.provider = oldUpdater.provider;
        this.observers.addAll(oldUpdater.observers);
        this.prevUpdater = oldUpdater;
    }

    private PreviewUpdater(FileCache cache, RenderedImage image, ImageMetadata meta) {
        ++DebugPreviewCount;
        if (Debug) {
            System.out.println(meta.getFile().getName() + " PreviewUpdater " + DebugPreviewCount + " instantiated");
        }
        this.cache = cache;
        this.image = image;
        this.meta = meta;
        this.observers = new HashSet<Observer>();
        this.stillInterested = true;
        this.setName("Preview Image " + meta.getFile().getName());
    }

    public File getFile() {
        return this.meta.getFile();
    }

    public synchronized RenderedImage getImage(Observer observer) {
        if (!this.done && !this.isAlive()) {
            RenderedImage cachedImage = null;
            ImageType t = this.meta.getImageType();
            if (t != null && t.hasFastPreview()) {
                cachedImage = Thumbnailer.getImage(this.meta.getFile(), 1536, false);
            }
            if (cachedImage == null) {
                cachedImage = this.readCache();
            }
            if (cachedImage != null) {
                this.image = Thumbnailer.rotate(cachedImage, this.meta);
                this.image = FastImageFactory.systemColorSpaceImage(this.image);
                this.done = true;
            } else {
                this.start();
            }
        }
        if (observer != null) {
            this.observers.add(observer);
        }
        return this.image;
    }

    private synchronized void updateImage(RenderedImage image) {
        this.image = image;
        this.notifyObservers();
    }

    private synchronized void notifyObservers() {
        final LinkedList<Observer> obs = new LinkedList<Observer>(this.observers);
        final RenderedImage im = this.image;
        final PreviewUpdater updater = this.getOriginalUpdater();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Observer observer : obs) {
                    observer.imageChanged(updater, im);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.prevUpdater != null) {
            while (!this.prevUpdater.done && this.prevUpdater.isAlive()) {
                Object object = Monitor;
                synchronized (object) {
                    try {
                        Monitor.wait(100L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
        }
        this.notifyStart();
        try {
            File file = this.meta.getFile();
            Object object = Monitor;
            synchronized (object) {
                if (this.stillInterested) {
                    RenderedImage preview;
                    if (Debug) {
                        System.out.println(this.meta.getFile().getName() + " PreviewUpdater running");
                    }
                    if ((preview = this.readCache()) == null) {
                        if (this.provider != null) {
                            preview = this.provider.getPreviewImage(file, 1536);
                        }
                        if (preview == null) {
                            preview = this.meta.getImageType() instanceof RawImageType ? Thumbnailer.getImage(file, 1536) : (this.meta.getImageType() == LZNImageType.INSTANCE ? Thumbnailer.getImage(file, 1536) : Thumbnailer.getImage(file, 1536));
                        }
                        if (preview == null) {
                            System.out.println("All preview methods fail for " + file);
                            this.notifyEnd();
                            this.done = true;
                            return;
                        }
                        if (this.cache != null) {
                            this.writeCache(preview);
                        }
                    }
                    preview = Thumbnailer.rotate(preview, this.meta);
                    preview = FastImageFactory.systemColorSpaceImage(preview);
                    this.updateImage(preview);
                }
            }
        }
        finally {
            this.notifyEnd();
            this.done = true;
        }
        {
            return;
        }
    }

    void dispose() {
        if (Debug) {
            System.out.println(this.meta.getFile().getName() + " PreviewUpdater " + DebugPreviewCount + " disposed");
        }
        --DebugPreviewCount;
        if (this.prevUpdater != null) {
            this.prevUpdater.dispose();
        }
        this.stillInterested = false;
        this.done = true;
        this.image = null;
    }

    private void notifyStart() {
        if (this.provider != null) {
            this.provider.previewStarted();
        }
    }

    private void notifyEnd() {
        if (this.provider != null) {
            this.provider.previewEnded();
        }
    }

    private void writeCache(RenderedImage image) {
        if (this.cache == null) {
            return;
        }
        String key = this.getImageKey();
        try {
            FileOutputStream out = this.cache.putToStream(key);
            OutputStreamImageDataReceiver receiver = new OutputStreamImageDataReceiver(out);
            try {
                LCJPEGWriter writer = new LCJPEGWriter(receiver, 32768, image.getWidth(), image.getHeight(), image.getColorModel().getNumComponents(), 2, 90);
                writer.putImage(image);
                writer.dispose();
            }
            catch (LCImageLibException e) {
                this.logNonFatal(e, "caching preview");
                this.cache.remove(key);
            }
            ((OutputStream)out).close();
            receiver.dispose();
        }
        catch (IOException e) {
            this.logNonFatal(e, "caching preview");
            this.removeCacheSilent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RenderedImage readCache() {
        PlanarImage planarImage;
        String key = this.getImageKey();
        if (this.cache == null || !this.cache.contains(key)) {
            return null;
        }
        FileInputStream in = this.cache.getStreamFor(key);
        try {
            ImageProviderReceiver provRecv = new ImageProviderReceiver();
            provRecv.fill(in);
            LCJPEGReader jpeg = new LCJPEGReader(provRecv, 1536, 1536);
            planarImage = jpeg.getImage();
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (Throwable t1) {
                this.logNonFatal(t1, "reading cached preview");
                this.removeCacheSilent();
                return null;
            }
        }
        ((InputStream)in).close();
        return planarImage;
    }

    private String getImageKey() {
        File file = this.meta.getFile();
        return PreviewUpdater.getImageKey(file);
    }

    private static String getImageKey(File file) {
        return file.getAbsolutePath() + "_preview_image";
    }

    private PreviewUpdater getOriginalUpdater() {
        if (this.prevUpdater != null) {
            return this.prevUpdater.getOriginalUpdater();
        }
        return this;
    }

    private void logNonFatal(Throwable t, String message) {
        File file = this.meta.getFile();
        PreviewUpdater.logNonFatalStatic(file, t, message);
    }

    private static void logNonFatalStatic(File file, Throwable t, String message) {
        StringBuilder sb = new StringBuilder();
        sb.append(file.getAbsolutePath());
        sb.append(' ');
        sb.append(message);
        sb.append(' ');
        sb.append(t.getClass().getName());
        if (t.getMessage() != null) {
            sb.append(": ");
            sb.append(t.getMessage());
        }
        System.err.println(sb);
    }

    private void removeCacheSilent() {
        File file = this.meta.getFile();
        PreviewUpdater.removeCacheSilentStatic(this.cache, file);
    }

    private static void removeCacheSilentStatic(FileCache cache, File file) {
        String key = PreviewUpdater.getImageKey(file);
        try {
            cache.remove(key);
        }
        catch (Throwable t) {
            PreviewUpdater.logNonFatalStatic(file, t, "removing cached preview");
        }
    }

    public static interface Observer {
        public void imageChanged(PreviewUpdater var1, RenderedImage var2);
    }

    public static interface Provider {
        public RenderedImage getPreviewImage(File var1, int var2);

        public void previewStarted();

        public void previewEnded();
    }
}

