/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.model;

import com.lightcrafts.image.ImageFileFilter;
import com.lightcrafts.ui.browser.model.ImageDatum;
import com.lightcrafts.ui.browser.model.ImageDatumComparator;
import com.lightcrafts.ui.browser.model.ImageGroup;
import com.lightcrafts.ui.browser.model.ImageGroupProvider;
import com.lightcrafts.ui.browser.model.ImageListListener;
import com.lightcrafts.ui.browser.model.ImageListPoller;
import com.lightcrafts.ui.browser.model.ImageTaskQueue;
import com.lightcrafts.ui.browser.model.ImageTaskQueueListener;
import com.lightcrafts.utils.ProgressIndicator;
import com.lightcrafts.utils.file.FileUtil;
import com.lightcrafts.utils.filecache.FileCache;
import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class ImageList {
    private List<ImageDatum> list;
    private int size;
    private ImageTaskQueue queue;
    private FileCache cache;
    private ImageListPoller poller;
    private ImageDatumComparator comp;
    private ImageGroupProvider groups;
    private LinkedList<ImageListListener> listeners;
    private int pauseDepth;
    private boolean wasCancelled;
    private static boolean cancel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageList(File directory, int size, FileCache cache, boolean useCache, ImageDatumComparator comp, ProgressIndicator progress) {
        this.size = size;
        this.cache = cache;
        this.comp = comp;
        this.list = Collections.synchronizedList(new LinkedList());
        this.queue = new ImageTaskQueue();
        this.poller = new ImageListPoller(this, directory);
        this.listeners = new LinkedList();
        List<ImageDatum> list = this.list;
        synchronized (list) {
            File[] files = FileUtil.listFiles(directory, ImageFileFilter.INSTANCE, false);
            if (files != null) {
                progress.setMinimum(0);
                progress.setMaximum(files.length);
                for (int n = 0; n < files.length && !cancel; ++n) {
                    File file = files[n];
                    ImageDatum datum = new ImageDatum(file, size, this.queue, cache);
                    datum.getMetadata(useCache);
                    this.list.add(datum);
                    progress.incrementBy(1);
                }
            } else {
                cancel = true;
            }
            if (cancel) {
                this.queue.removeAllTasks();
                this.list.clear();
                this.wasCancelled = true;
                cancel = false;
            }
            this.sort();
        }
    }

    public static void cancel() {
        cancel = true;
    }

    public void start() {
        if (!this.wasCancelled) {
            this.queue.start();
            this.poller.start();
        }
    }

    public void pause() {
        if (this.pauseDepth++ == 0 && !this.wasCancelled) {
            this.queue.pause();
            this.poller.pause();
        }
    }

    public void resume() {
        assert (this.pauseDepth > 0) : "Unbalanced browser resume";
        if (--this.pauseDepth == 0 && !this.wasCancelled) {
            this.queue.resume();
            this.poller.resume();
        }
    }

    public int getPauseDepth() {
        return this.pauseDepth;
    }

    public void stop() {
        if (!this.wasCancelled) {
            this.queue.stop();
            this.poller.stop();
        }
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    public void addImageListListener(ImageListListener listener) {
        this.listeners.add(listener);
    }

    public void removeImageListListener(ImageListListener listener) {
        this.listeners.remove(listener);
    }

    public void setSort(ImageDatumComparator comp) {
        this.comp = comp;
        this.sort();
        this.notifyReordered();
    }

    public void setSortInverted(boolean inverted) {
        this.comp.setReversed(inverted);
        this.sort();
        this.notifyReordered();
    }

    public void regroup() {
        this.sort();
        this.notifyReordered();
    }

    public void setImageGroupProvider(ImageGroupProvider groups) {
        this.groups = groups;
        this.sort();
        this.notifyReordered();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(int size) {
        this.size = size;
        List<ImageDatum> list = this.list;
        synchronized (list) {
            for (ImageDatum datum : this.list) {
                datum.setSize(size);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ImageDatum> getAllImageData() {
        List<ImageDatum> list = this.list;
        synchronized (list) {
            return new ArrayList<ImageDatum>(this.list);
        }
    }

    public int getSize() {
        return this.size;
    }

    public void addQueueListener(ImageTaskQueueListener listener) {
        this.queue.addListener(listener);
    }

    public void removeQueueListener(ImageTaskQueueListener listener) {
        this.queue.removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFile(File file) {
        final ImageDatum datum = new ImageDatum(file, this.size, this.queue, this.cache);
        datum.refresh(false);
        List<ImageDatum> list = this.list;
        synchronized (list) {
            this.list.add(datum);
            this.sort();
            final int index = this.list.indexOf(datum);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImageList.this.notifyAdded(datum, index);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeImageData(final ImageDatum datum) {
        List<ImageDatum> list = this.list;
        synchronized (list) {
            final int index = this.list.indexOf(datum);
            this.list.remove(datum);
            this.sort();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImageList.this.notifyRemoved(datum, index);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void metadataChanged(ImageDatum datum) {
        int newIndex;
        int oldIndex;
        List<ImageDatum> list = this.list;
        synchronized (list) {
            oldIndex = this.list.indexOf(datum);
            this.sort();
            newIndex = this.list.indexOf(datum);
        }
        if (oldIndex != newIndex) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImageList.this.notifyReordered();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sort() {
        List<ImageDatum> list = this.list;
        synchronized (list) {
            if (this.groups != null) {
                this.groups.cluster(this.list);
            }
            HashSet<ImageGroup> groups = new HashSet<ImageGroup>();
            for (ImageDatum datum : this.list) {
                ImageGroup group = datum.getGroup();
                groups.add(group);
            }
            LinkedList<ImageDatum> leaders = new LinkedList<ImageDatum>();
            for (ImageGroup group : groups) {
                ImageDatum leader = group.getLeader();
                if (leaders.contains(leader)) {
                    System.out.println("redundant leader");
                }
                leaders.add(leader);
            }
            Collections.sort(leaders, this.comp);
            this.list.clear();
            for (ImageDatum leader : leaders) {
                this.list.add(leader);
                ImageGroup group = leader.getGroup();
                List<ImageDatum> members = group.getImageDatums();
                Collections.sort(members, new Comparator<ImageDatum>(){

                    @Override
                    public int compare(ImageDatum left, ImageDatum right) {
                        File leftFile = left.getFile();
                        File rightFile = right.getFile();
                        long leftTime = leftFile.lastModified();
                        long rightTime = rightFile.lastModified();
                        return (int)Math.signum(leftTime - rightTime);
                    }
                });
                for (ImageDatum member : members) {
                    if (member.equals(leader)) continue;
                    this.list.add(member);
                }
            }
        }
    }

    private void notifyAdded(ImageDatum datum, int index) {
        for (ImageListListener listener : this.listeners) {
            listener.imageAdded(this, datum, index);
        }
    }

    private void notifyRemoved(ImageDatum datum, int index) {
        for (ImageListListener listener : this.listeners) {
            listener.imageRemoved(this, datum, index);
        }
    }

    private void notifyReordered() {
        for (ImageListListener listener : this.listeners) {
            listener.imagesReordered(this);
        }
    }

    private void showPauseContext() {
        System.out.println("PAUSE " + (this.pauseDepth + 1));
        System.out.println('\t' + Thread.currentThread().getName());
        System.out.println('\t' + this.toString());
        Throwable t = new Throwable();
        StackTraceElement[] stack = t.getStackTrace();
        int n = 0;
        for (StackTraceElement frame : stack) {
            String name;
            if (++n < 4 || (name = frame.getClassName()).contains("java.awt.") || name.contains("javax.swing.")) continue;
            System.out.println("\tat " + frame);
        }
    }

    private void showResumeContext() {
        System.out.println("RESUME " + this.pauseDepth);
        System.out.println('\t' + Thread.currentThread().getName());
        System.out.println('\t' + this.toString());
        Throwable t = new Throwable();
        StackTraceElement[] stack = t.getStackTrace();
        int n = 0;
        for (StackTraceElement frame : stack) {
            String name;
            if (++n < 4 || (name = frame.getClassName()).contains("java.awt.") || name.contains("javax.swing.")) continue;
            System.out.println("\tat " + frame);
        }
    }
}

