/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.model;

import com.lightcrafts.image.metadata.CoreDirectory;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.ui.browser.model.ImageDatum;
import com.lightcrafts.ui.browser.model.Locale;
import java.util.ArrayList;
import java.util.Comparator;

public class ImageDatumComparator
implements Comparator<ImageDatum> {
    private static ArrayList<ImageDatumComparator> AllDatums = new ArrayList();
    public static ImageDatumComparator Name = new ImageDatumComparator(3, Locale.LOCALE.get("FileNameSort"), false);
    public static ImageDatumComparator CaptureTime = new ImageDatumComparator(264, Locale.LOCALE.get("CaptureTimeSort"), false);
    public static ImageDatumComparator Rating = new ImageDatumComparator(518, Locale.LOCALE.get("RatingSort"), false);
    public static ImageDatumComparator ModificationTime = new ImageDatumComparator(1, Locale.LOCALE.get("ModTimeSort"), false);
    public static ImageDatumComparator Aperture = new ImageDatumComparator(257, Locale.LOCALE.get("ApertureSort"), false);
    public static ImageDatumComparator Speed = new ImageDatumComparator(259, Locale.LOCALE.get("ShutterSort"), false);
    public static ImageDatumComparator Size = new ImageDatumComparator(4, Locale.LOCALE.get("SizeSort"), false);
    public static ImageDatumComparator Lens = new ImageDatumComparator(260, Locale.LOCALE.get("LensSort"), false);
    public static ImageDatumComparator FocalLength = new ImageDatumComparator(261, Locale.LOCALE.get("FocalLengthSort"), false);
    boolean reverse;
    private int tagId;
    private String name;

    private ImageDatumComparator(int tagId, String name, boolean reverse) {
        this.tagId = tagId;
        this.name = name;
        this.reverse = reverse;
        AllDatums.add(this);
    }

    public static ImageDatumComparator[] getAll() {
        return AllDatums.toArray(new ImageDatumComparator[0]);
    }

    @Override
    public int compare(ImageDatum left, ImageDatum right) {
        ImageDatum leftLeader = left.getGroup().getLeader();
        ImageDatum rightLeader = right.getGroup().getLeader();
        if (leftLeader != null) {
            left = leftLeader;
        }
        if (rightLeader != null) {
            right = rightLeader;
        }
        ImageMetadata metaLeft = left.getMetadata(true);
        ImageMetadata metaRight = right.getMetadata(true);
        Class<CoreDirectory> clazz = CoreDirectory.class;
        ImageMetaValue leftValue = metaLeft.getValue(clazz, this.tagId);
        ImageMetaValue rightValue = metaRight.getValue(clazz, this.tagId);
        if (leftValue != null && rightValue != null) {
            if (!this.reverse) {
                int comp = leftValue.compareTo(rightValue);
                if (comp == 0) {
                    comp = this.compareNames(left, right);
                }
                return comp;
            }
            int comp = rightValue.compareTo(leftValue);
            if (comp == 0) {
                comp = this.compareNames(left, right);
            }
            return comp;
        }
        if (leftValue != null && rightValue == null) {
            return this.reverse ? -1 : 1;
        }
        if (leftValue == null && rightValue != null) {
            return this.reverse ? 1 : -1;
        }
        return this.compareNames(left, right);
    }

    void setReversed(boolean reverse) {
        this.reverse = reverse;
    }

    int getTagId() {
        return this.tagId;
    }

    public String toString() {
        return this.name;
    }

    private int compareNames(ImageDatum left, ImageDatum right) {
        ImageDatum leftLeader = left.getGroup().getLeader();
        ImageDatum rightLeader = right.getGroup().getLeader();
        if (leftLeader != null) {
            left = leftLeader;
        }
        if (rightLeader != null) {
            right = rightLeader;
        }
        ImageMetadata metaLeft = left.getMetadata(true);
        ImageMetadata metaRight = right.getMetadata(true);
        Class<CoreDirectory> clazz = CoreDirectory.class;
        ImageMetaValue leftValue = metaLeft.getValue(clazz, 3);
        ImageMetaValue rightValue = metaRight.getValue(clazz, 3);
        if (leftValue != null && rightValue != null) {
            if (!this.reverse) {
                int comp = leftValue.compareTo(rightValue);
                return comp;
            }
            int comp = rightValue.compareTo(leftValue);
            return comp;
        }
        if (leftValue != null && rightValue == null) {
            return this.reverse ? -1 : 1;
        }
        if (leftValue == null && rightValue != null) {
            return this.reverse ? 1 : -1;
        }
        return 0;
    }
}

