/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.folders;

import com.lightcrafts.ui.browser.folders.FolderFilter;
import java.io.File;
import java.util.HashSet;
import java.util.regex.Pattern;

class MacOSXFolderFilter
extends FolderFilter {
    private static final HashSet<String> HiddenDirectories;
    private static final Pattern VolumePattern;

    MacOSXFolderFilter() {
    }

    @Override
    public boolean accept(File file) {
        if (!super.accept(file)) {
            return false;
        }
        String parent = file.getParent();
        if (!parent.equals("/") && !VolumePattern.matcher(parent).matches()) {
            return true;
        }
        if (VolumePattern.matcher(parent).matches() && file.getName().equals("tmp")) {
            return true;
        }
        return !HiddenDirectories.contains(file.getName());
    }

    static {
        String[] hiddenDirectories;
        HiddenDirectories = new HashSet();
        for (String dir : hiddenDirectories = new String[]{"automount", "bin", "cores", "dev", "etc", "Library", "lost+found", "opt", "private", "sbin", "System", "tmp", "usr", "var", "Volumes"}) {
            HiddenDirectories.add(dir);
        }
        VolumePattern = Pattern.compile("^/Volumes/[^/]*$");
    }
}

