/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.folders;

import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.browser.folders.FolderFilter;
import com.lightcrafts.ui.browser.folders.FolderTreeNodeComparator;
import com.lightcrafts.ui.browser.folders.MacOSXRootTreeNode;
import com.lightcrafts.ui.browser.folders.NodeFileIndex;
import com.lightcrafts.utils.directory.DirectoryMonitor;
import com.lightcrafts.utils.file.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class FolderTreeNode
implements TreeNode {
    private static final FileSystemView FileSystemView = Platform.getPlatform().getFileSystemView();
    private List<FolderTreeNode> children;
    private FolderTreeNode parent;
    private NodeFileIndex index;
    private DirectoryMonitor monitor;
    private File file;
    private File resolvedFile;
    private Icon icon;
    private Boolean isLeaf;
    private String name;
    private boolean isDropTarget;

    static FolderTreeNode createRoot() {
        NodeFileIndex index = new NodeFileIndex();
        DirectoryMonitor monitor = Platform.getPlatform().getDirectoryMonitor();
        if (Platform.getType() == Platform.MacOSX) {
            return new MacOSXRootTreeNode(index, monitor);
        }
        File[] roots = FileSystemView.getRoots();
        return new FolderTreeNode(roots[0], null, index, monitor);
    }

    FolderTreeNode(File file, FolderTreeNode parent, NodeFileIndex index, DirectoryMonitor monitor) {
        this.file = file;
        this.parent = parent;
        this.index = index;
        this.monitor = monitor;
        this.resolvedFile = FileUtil.resolveAliasFile(this.file);
        try {
            File canonicalFile;
            this.resolvedFile = canonicalFile = this.resolvedFile.getCanonicalFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        index.add(this);
        monitor.addDirectory(this.resolvedFile);
    }

    void setIsDropTarget(boolean isTarget) {
        this.isDropTarget = isTarget;
    }

    boolean isDropTarget() {
        return this.isDropTarget;
    }

    public Enumeration<FolderTreeNode> children() {
        final Iterator<FolderTreeNode> i = this.getChildren().iterator();
        return new Enumeration<FolderTreeNode>(){

            @Override
            public boolean hasMoreElements() {
                return i.hasNext();
            }

            @Override
            public FolderTreeNode nextElement() {
                return (FolderTreeNode)i.next();
            }
        };
    }

    public boolean equals(Object o) {
        if (!(o instanceof FolderTreeNode)) {
            return false;
        }
        FolderTreeNode node = (FolderTreeNode)o;
        return this.file.equals(node.file);
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.isLeaf();
    }

    @Override
    public TreeNode getChildAt(int index) {
        return this.getChildren().get(index);
    }

    @Override
    public int getChildCount() {
        return this.getChildren().size();
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.getChildren().indexOf(node);
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    public boolean isLeaf() {
        if (this.isLeaf == null) {
            this.isLeaf = FolderTreeNode.isLeaf(this.file);
        }
        return this.isLeaf;
    }

    public String toString() {
        if (this.name == null) {
            this.name = Platform.getPlatform().getDisplayNameOf(this.file);
        }
        return this.name;
    }

    FolderTreeNode getChildByName(String name) {
        for (FolderTreeNode child : this.getChildren()) {
            if (!name.equals(child.toString())) continue;
            return child;
        }
        return null;
    }

    File getFile() {
        return this.resolvedFile;
    }

    Icon getIcon() {
        if (this.icon == null && this.file != null) {
            try {
                this.icon = FileSystemView.getSystemIcon(this.file);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.icon;
    }

    TreePath getTreePath() {
        ArrayList<FolderTreeNode> path = new ArrayList<FolderTreeNode>();
        for (TreeNode node = this; node != null; node = node.getParent()) {
            path.add(0, (FolderTreeNode)node);
        }
        return new TreePath(path.toArray());
    }

    boolean hasSpecialIcon() {
        return FileSystemView.isDrive(this.file) || FileSystemView.isFileSystem(this.file) || FileSystemView.isRoot(this.file);
    }

    void updateChildren() {
        if (this.children != null) {
            for (FolderTreeNode child : this.children) {
                this.monitor.removeDirectory(child.resolvedFile);
                this.index.remove(child);
                child.parent = null;
            }
        }
        this.children = new ArrayList<FolderTreeNode>();
        Object[] files = FileUtil.listFiles(this.resolvedFile, FolderFilter.INSTANCE, false);
        if (files != null && files.length > 0) {
            Arrays.sort(files);
            for (Object file : files) {
                this.children.add(new FolderTreeNode((File)file, this, this.index, this.monitor));
            }
        }
        Collections.sort(this.children, FolderTreeNodeComparator.INSTANCE);
    }

    NodeFileIndex getIndex() {
        return this.index;
    }

    DirectoryMonitor getDirectoryMonitor() {
        return this.monitor;
    }

    List<FolderTreeNode> getChildren() {
        if (this.children == null) {
            this.updateChildren();
        }
        return this.children;
    }

    private static boolean isLeaf(File file) {
        if (FileSystemView.isDrive(file) || FileSystemView.isFileSystemRoot(file) || FileSystemView.isFloppyDrive(file) || FileSystemView.isRoot(file)) {
            return false;
        }
        return (file = FileUtil.isFolder(file)) == null;
    }
}

